/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kz.greetgo.depinject.core.Bean;
import kz.greetgo.depinject.core.BeanGetter;
import kz.greetgo.depinject.core.HideFromDepinject;
import kz.greetgo.depinject.gen.BeanConfigTree;
import kz.greetgo.depinject.gen.BeanContainerManager;
import kz.greetgo.depinject.gen.BeanContainerMethod;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.BeanCreationCollector;
import kz.greetgo.depinject.gen.BeanCreationWithBeanFactory;
import kz.greetgo.depinject.gen.BeanCreationWithConstructor;
import kz.greetgo.depinject.gen.BeanCreationWithFactoryMethod;
import kz.greetgo.depinject.gen.BeanGetterInPublicField;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.BeanReferencePlace;
import kz.greetgo.depinject.gen.ConstructorArg;
import kz.greetgo.depinject.gen.errors.BeanContainerMethodCannotContainAnyArguments;
import kz.greetgo.depinject.gen.errors.IllegalBeanGetterDefinition;
import kz.greetgo.depinject.gen.errors.ManyCandidates;
import kz.greetgo.depinject.gen.errors.MismatchConstructorPropertiesCount;
import kz.greetgo.depinject.gen.errors.NoAnnotationConstructorProperties;
import kz.greetgo.depinject.gen.errors.NoBeanConfig;
import kz.greetgo.depinject.gen.errors.NoCandidates;
import kz.greetgo.depinject.gen.errors.NoConstructorsToCreateBean;
import kz.greetgo.depinject.gen.errors.NoDefaultBeanFactory;
import kz.greetgo.depinject.gen.errors.QualifierNotMatched;
import kz.greetgo.depinject.gen.errors.SuitableConstructorContainsIllegalArgument;

public class Context {
    public final BeanConfigTree configTree = new BeanConfigTree();

    public BeanContainerManager createManager(Class<?> beanContainerInterface) {
        return new BeanContainerManager(this, beanContainerInterface);
    }

    public BeanCreationCollector newBeanCreationCollector(Class<?> beanContainerInterface) {
        return new BeanCreationCollector(this, beanContainerInterface);
    }

    public NoBeanConfig newNoBeanConfig(Class<?> beanConfig) {
        return new NoBeanConfig(beanConfig);
    }

    public BeanReference newBeanReference(Type target, BeanReference.Place place) {
        return new BeanReference(this, target, place);
    }

    public BeanCreation newBeanCreationWithBeanFactory(Class<?> parentBeanClass, Bean bean, BeanReference beanReference) {
        return new BeanCreationWithBeanFactory(this, parentBeanClass, bean, beanReference);
    }

    public NoDefaultBeanFactory newNoDefaultBeanFactory(Class<?> beanClass) {
        return new NoDefaultBeanFactory(beanClass, this.configTree);
    }

    public NoCandidates newNoCandidates(BeanReference beanReference) {
        return new NoCandidates(beanReference, this.configTree);
    }

    public RuntimeException newQualifierNotMatched(BeanReference beanReference) {
        return new QualifierNotMatched(beanReference, this.configTree);
    }

    public ManyCandidates newManyCandidates(BeanReference beanReference) {
        return new ManyCandidates(beanReference, this.configTree);
    }

    public List<BeanContainerMethod> extractBeanContainerMethodList(Class<?> beanContainer) {
        ArrayList<BeanContainerMethod> ret = new ArrayList<BeanContainerMethod>();
        for (Method method : beanContainer.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (method.getParameterTypes().length > 0) {
                throw new BeanContainerMethodCannotContainAnyArguments(beanContainer, method);
            }
            ret.add(new BeanContainerMethod(this, method));
        }
        Collections.sort(ret);
        return ret;
    }

    public BeanCreationWithFactoryMethod newBeanCreationWithFactoryMethod(Class<?> returnType, Bean bean, BeanCreation parentBeanCreation, Method method) {
        return new BeanCreationWithFactoryMethod(this, returnType, bean, parentBeanCreation, method);
    }

    void fillBeanGetterHolderListInner(List<BeanGetterInPublicField> beanGetterInPublicFieldList, Class<?> beanClass) {
        for (Field field : beanClass.getFields()) {
            if (field.getType() != BeanGetter.class) continue;
            this.addHolder(beanGetterInPublicFieldList, field, beanClass);
        }
        Collections.sort(beanGetterInPublicFieldList);
    }

    private void addHolder(List<BeanGetterInPublicField> list, Field field, Class<?> beanClass) {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            throw new IllegalBeanGetterDefinition(beanClass, field.getName());
        }
        ParameterizedType pt = (ParameterizedType)field.getGenericType();
        Type referencingClass = pt.getActualTypeArguments()[0];
        BeanReference.Place place = BeanReferencePlace.placeInPublicBeanGetter(referencingClass, beanClass, field);
        BeanReference beanReference = this.newBeanReference(referencingClass, place);
        list.add(new BeanGetterInPublicField(field.getName(), beanReference));
    }

    public BeanCreation newBeanCreationWithConstructor(final Class<?> beanClass, Bean bean) {
        class ArgSet {
            final List<ConstructorArg> argList;
            final Constructor<?> constructor;

            public ArgSet(Constructor<?> constructor, List<ConstructorArg> argList) {
                this.argList = argList;
                this.constructor = constructor;
            }

            public void validateArguments() {
                if (this.argList.size() > 0) {
                    ConstructorProperties cp = this.constructor.getAnnotation(ConstructorProperties.class);
                    if (cp == null) {
                        throw new NoAnnotationConstructorProperties(beanClass, this.constructor);
                    }
                    if (cp.value().length != this.argList.size()) {
                        throw new MismatchConstructorPropertiesCount(beanClass, cp.value().length, this.constructor, this.argList.size());
                    }
                }
                int argIndex = 0;
                for (ConstructorArg constructorArg : this.argList) {
                    if (constructorArg.beanReference == null) {
                        throw new SuitableConstructorContainsIllegalArgument(argIndex, this.constructor, beanClass);
                    }
                    ++argIndex;
                }
            }
        }
        ArrayList<ArgSet> argSetList = new ArrayList<ArgSet>();
        for (Constructor<?> constructor : beanClass.getConstructors()) {
            if (constructor.getAnnotation(HideFromDepinject.class) != null) continue;
            ArrayList<ConstructorArg> argList = new ArrayList<ConstructorArg>();
            int argIndex = 0;
            for (Type argType : constructor.getGenericParameterTypes()) {
                if (!(argType instanceof ParameterizedType)) {
                    argList.add(new ConstructorArg(argType, null));
                    ++argIndex;
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)argType;
                if (parameterizedType.getRawType() != BeanGetter.class) {
                    argList.add(new ConstructorArg(argType, null));
                    ++argIndex;
                    continue;
                }
                Type referencingType = parameterizedType.getActualTypeArguments()[0];
                BeanReference.Place place = BeanReferencePlace.placeInConstructorArg(referencingType, argType, argIndex, beanClass, constructor);
                BeanReference beanReference = this.newBeanReference(referencingType, place);
                argList.add(new ConstructorArg(argType, beanReference));
                ++argIndex;
            }
            argSetList.add(new ArgSet(constructor, argList));
        }
        if (argSetList.isEmpty()) {
            throw new NoConstructorsToCreateBean(beanClass);
        }
        argSetList.sort(Collections.reverseOrder(Comparator.comparing(a -> a.argList.size())));
        ((ArgSet)argSetList.get(0)).validateArguments();
        List<ConstructorArg> selectedArgList = ((ArgSet)argSetList.get((int)0)).argList;
        return new BeanCreationWithConstructor(this, beanClass, bean, selectedArgList);
    }
}

