/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kz.greetgo.depinject.core.BeanGetter;
import kz.greetgo.depinject.core.replace.BeanReplacer;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.Outer;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.LeftException;

public class GetterCreation {
    public final Class<?> getterClass;
    public final BeanCreation beanCreation;
    public boolean use = false;
    public final List<BeanCreation> preparations = new ArrayList<BeanCreation>();
    public int varIndex = 0;
    private boolean wasUsePreparations = false;
    public final List<BeanCreation> replacers = new ArrayList<BeanCreation>();
    private boolean wasUseReplacers = false;

    public GetterCreation(Class<?> getterClass, BeanCreation beanCreation) {
        if (getterClass == null) {
            throw new NullPointerException("getterClass == null");
        }
        if (beanCreation == null) {
            throw new NullPointerException("beanCreation == null");
        }
        this.getterClass = getterClass;
        this.beanCreation = beanCreation;
    }

    public String toString() {
        return "GetterCreation{(" + this.varIndex + ") " + Utils.asStr(this.getterClass) + " := " + this.beanCreation;
    }

    public void markToUse() {
        if (this.use) {
            return;
        }
        this.use = true;
        this.beanCreation.markToUse();
        this.preparations.forEach(BeanCreation::markToUse);
        this.replacers.forEach(BeanCreation::markToUse);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetterCreation that = (GetterCreation)o;
        if (!this.beanCreation.equals(that.beanCreation)) {
            return false;
        }
        if (!this.preparations.equals(that.preparations)) {
            return false;
        }
        if (!this.replacers.equals(that.replacers)) {
            return false;
        }
        return this.replacers.size() <= 0 || this.getterClass.equals(that.getterClass);
    }

    public int hashCode() {
        int result = this.beanCreation.hashCode();
        result = 31 * result + this.preparations.hashCode();
        result = 31 * result + this.replacers.hashCode();
        if (this.replacers.size() > 0) {
            result = 31 * result + this.getterClass.hashCode();
        }
        return result;
    }

    public boolean needGetter() {
        return this.preparations.size() > 0 || this.replacers.size() > 0;
    }

    private String className() {
        return this.beanCreation.beanClass.getSimpleName();
    }

    private int varIndex() {
        if (this.varIndex <= 0) {
            throw new RuntimeException("Left var index = " + this.varIndex);
        }
        return this.varIndex;
    }

    public void usePreparations(List<BeanCreation> allPreparations) {
        if (this.wasUsePreparations) {
            return;
        }
        this.wasUsePreparations = true;
        Class<?> currentClass = this.beanCreation.beanClass;
        for (BeanCreation preparation : allPreparations) {
            Class<?> pc = preparation.preparingClass;
            if (pc == null || !pc.isAssignableFrom(currentClass) || !this.getterClass.isAssignableFrom(pc)) continue;
            this.preparations.add(preparation);
            currentClass = pc;
        }
    }

    public String preparationStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t").append(Utils.asStr(this.getterClass)).append(" -> ").append(this.beanCreation);
        for (BeanCreation preparation : this.preparations) {
            sb.append("\n\t\t\t\tprepared by ").append(preparation);
        }
        for (BeanCreation replacer : this.replacers) {
            sb.append("\n\t\t\t\treplaced by ").append(replacer);
        }
        return sb.toString();
    }

    public void writeGetter(int tab, Outer outer) {
        if (!this.needGetter()) {
            return;
        }
        if (this.beanCreation.isSingleton()) {
            this.writeGetterSingleton(tab, outer);
        } else {
            this.writeGetterMulti(tab, outer);
        }
    }

    private String applyPreparations(int tab, Outer outer, String inVarName) {
        String current = inVarName;
        int i = 1;
        for (BeanCreation p : this.preparations) {
            String newVar = inVarName + '_' + i++;
            outer.tab(tab).stn(Utils.codeName(p.preparingClass) + " " + newVar + " = " + p.getterVarName() + ".get().prepareBean(" + current + ");");
            current = newVar;
        }
        return current;
    }

    private String applyReplacers(int tab, Outer o, String varName) {
        String var = null;
        for (BeanCreation replacer : this.replacers) {
            if (var == null) {
                var = "replacer_" + varName;
                o.tab(tab).stn(Utils.codeName(this.getterClass) + ' ' + var + " = " + this.replaceCode(replacer, varName) + ';');
                continue;
            }
            o.tab(tab).stn(var + " = " + this.replaceCode(replacer, var) + ';');
        }
        return var == null ? varName : var;
    }

    private String replaceCode(BeanCreation replacer, String varName) {
        return "(" + Utils.codeName(this.getterClass) + ") " + replacer.getterVarName() + ".get().replaceBean(" + varName + ", " + Utils.codeName(this.getterClass) + ".class)";
    }

    public String getterVarName() {
        return this.needGetter() ? "getter_withPreparations_" + this.className() + '_' + this.varIndex() : this.beanCreation.getterVarName();
    }

    private String cachedValueVarName() {
        if (!this.needGetter()) {
            throw new LeftException("gje4kkf556djd5h3");
        }
        return "cachedValue_withPreparations_" + this.className() + '_' + this.varIndex();
    }

    private String gettingMethodName() {
        if (!this.needGetter()) {
            throw new LeftException("hs74fh64h74ht56feh5");
        }
        return "get_withPreparations_" + this.className() + '_' + this.varIndex();
    }

    private void writeGetterSingleton(int tab, Outer o) {
        String getterClassName = Utils.codeName(this.getterClass);
        String beanClassName = Utils.codeName(this.beanCreation.beanClass);
        o.nl();
        o.tab(tab).stn("private final " + Utils.codeName(AtomicReference.class) + "<" + getterClassName + "> " + this.cachedValueVarName() + " = new " + Utils.codeName(AtomicReference.class) + "<>();");
        o.tab(tab).stn("private final " + Utils.codeName(BeanGetter.class) + "<" + getterClassName + "> " + this.getterVarName() + " = this::" + this.gettingMethodName() + ";");
        o.tab(tab).stn("private " + getterClassName + ' ' + this.gettingMethodName() + " () {");
        int tab1 = tab + 1;
        int tab2 = tab + 2;
        int tab3 = tab + 3;
        o.tab(tab1).stn("{");
        o.tab(tab2).stn(getterClassName + " x = " + this.cachedValueVarName() + ".get();");
        o.tab(tab2).stn("if (x != null) return x;");
        o.tab(tab1).stn("}");
        o.tab(tab1).stn("synchronized (forSynchronizedBlocks) {");
        o.tab(tab2).stn("{");
        o.tab(tab3).stn(getterClassName + " x = " + this.cachedValueVarName() + ".get();");
        o.tab(tab3).stn("if (x != null) return x;");
        o.tab(tab2).stn("}");
        o.tab(tab2).stn("{");
        o.tab(tab3).stn(beanClassName + " singleValue = " + this.beanCreation.getterVarName() + ".get();");
        String outPreparationsVarName = this.applyPreparations(tab3, o, "singleValue");
        String outReplacersVarName = this.applyReplacers(tab3, o, outPreparationsVarName);
        o.tab(tab3).stn(this.cachedValueVarName() + ".set(" + outReplacersVarName + ");");
        o.tab(tab3).stn("return " + outReplacersVarName + ';');
        o.tab(tab2).stn("}");
        o.tab(tab1).stn("}");
        o.tab(tab).stn("}");
    }

    private void writeGetterMulti(int tab, Outer o) {
        String getterClassName = Utils.codeName(this.getterClass);
        String beanClassName = Utils.codeName(this.beanCreation.beanClass);
        o.nl();
        o.tab(tab).stn("private final " + Utils.codeName(BeanGetter.class) + "<" + getterClassName + "> " + this.getterVarName() + " = this::" + this.gettingMethodName() + ";");
        o.tab(tab).stn("private " + getterClassName + ' ' + this.gettingMethodName() + " () {");
        int tab1 = tab + 1;
        o.tab(tab1).stn(beanClassName + " value = " + this.beanCreation.getterVarName() + ".get();");
        String outPreparationsVarName = this.applyPreparations(tab1, o, "value");
        String outReplacersVarName = this.applyReplacers(tab1, o, outPreparationsVarName);
        o.tab(tab1).stn("return " + outReplacersVarName + ';');
        o.tab(tab).stn("}");
    }

    public void useReplacers(List<BeanCreation> allReplacers) {
        if (this.wasUseReplacers) {
            return;
        }
        this.wasUseReplacers = true;
        Class<?> checkingClass = this.beanCreation.beanClass;
        if (BeanReplacer.class.isAssignableFrom(checkingClass)) {
            return;
        }
        for (BeanCreation replacer : allReplacers) {
            if (replacer.replaceChecker == null || !replacer.replaceChecker.check(checkingClass)) continue;
            this.replacers.add(replacer);
        }
    }
}

