/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import kz.greetgo.depinject.core.BeanConfig;
import kz.greetgo.depinject.core.FactoredBy;
import kz.greetgo.depinject.core.Qualifier;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.NoFieldSpecifiedInAnnotationConstructorProperties;

public class BeanReferencePlace {
    public static BeanReference.Place placeInPublicBeanGetter(final Type referencingClass, final Class<?> beanClass, final Field field) {
        return new BeanReference.Place(){

            @Override
            public BeanReference.PlaceType type() {
                return BeanReference.PlaceType.InPublicBeanGetter;
            }

            @Override
            public String display() {
                return "public field " + Utils.asStr(beanClass) + "." + field.getName() + " -> " + Utils.typeAsStr(referencingClass) + BeanReferencePlace.qualifierAsStr(this.qualifier());
            }

            @Override
            public Qualifier qualifier() {
                return Utils.noneNull(field.getAnnotation(Qualifier.class));
            }
        };
    }

    private static String qualifierAsStr(Qualifier qualifier) {
        if (qualifier == null || qualifier.value().isEmpty()) {
            return "";
        }
        return qualifier.regexp() ? " [id ~ /" + qualifier.value() + "/]" : " [id = " + qualifier.value() + "]";
    }

    public static BeanReference.Place placeInConstructorArg(final Type referencingType, Type argType, final int argIndex, final Class<?> beanClass, final Constructor<?> constructor) {
        return new BeanReference.Place(){

            @Override
            public BeanReference.PlaceType type() {
                return BeanReference.PlaceType.InConstructorArg;
            }

            @Override
            public String display() {
                return "argument " + argIndex + " of constructor in " + Utils.asStr(beanClass) + " -> " + Utils.typeAsStr(referencingType) + BeanReferencePlace.qualifierAsStr(this.qualifier());
            }

            @Override
            public Qualifier qualifier() {
                ConstructorProperties cp = constructor.getAnnotation(ConstructorProperties.class);
                assert (cp != null);
                Field field = Utils.findDeclaredField(beanClass, cp.value()[argIndex]).orElseThrow(() -> new NoFieldSpecifiedInAnnotationConstructorProperties(beanClass, cp.value()[argIndex], constructor));
                Qualifier fieldQualifier = field.getAnnotation(Qualifier.class);
                if (fieldQualifier != null) {
                    return fieldQualifier;
                }
                return Arrays.stream(constructor.getParameterAnnotations()[argIndex]).filter(a -> a instanceof Qualifier).map(a -> (Qualifier)a).findAny().orElse(Utils.noneNull(null));
            }
        };
    }

    public static BeanReference.Place placeInBeanFactory(final Class<?> beanConfig, final BeanConfig beanConfigAnn) {
        return new BeanReference.Place(){

            @Override
            public BeanReference.PlaceType type() {
                return BeanReference.PlaceType.InBeanFactory;
            }

            @Override
            public String display() {
                return "bean factory of " + Utils.asStr(beanConfig) + BeanReferencePlace.qualifierAsStr(this.qualifier());
            }

            @Override
            public Qualifier qualifier() {
                return Utils.beanConfigToQualifier(beanConfigAnn);
            }
        };
    }

    public static BeanReference.Place placeInAnnotationFactoredBy(final Class<?> beanClass, final FactoredBy factoredBy) {
        return new BeanReference.Place(){

            @Override
            public BeanReference.PlaceType type() {
                return BeanReference.PlaceType.InAnnotationFactoredBy;
            }

            @Override
            public String display() {
                return factoredBy.getClass().getSimpleName() + " in (or in any parents of) " + Utils.asStr(beanClass) + BeanReferencePlace.qualifierAsStr(this.qualifier());
            }

            @Override
            public Qualifier qualifier() {
                return Utils.factoredByToQualifier(factoredBy);
            }
        };
    }

    public static BeanReference.Place placeInBeanContainerMethod(final Method method) {
        return new BeanReference.Place(){

            @Override
            public BeanReference.PlaceType type() {
                return BeanReference.PlaceType.InBeanContainerMethod;
            }

            @Override
            public String display() {
                return "bean container method " + Utils.asStr(method.getDeclaringClass()) + "." + method.getName() + "()" + BeanReferencePlace.qualifierAsStr(this.qualifier());
            }

            @Override
            public Qualifier qualifier() {
                return Utils.noneNull(method.getAnnotation(Qualifier.class));
            }
        };
    }
}

