/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.testng;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import kz.greetgo.depinject.testng.DepinjectTestNg;
import kz.greetgo.util.ServerUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractDepinjectTestNg {
    String srcDir = null;

    @BeforeClass
    public void prepareDepinject() throws Exception {
        this.beforeGenerateTestSources();
        this.srcDir = DepinjectTestNg.prepareDepinjectTestNg(this, this.getSrcTempDir());
    }

    protected void beforeGenerateTestSources() throws Exception {
    }

    @AfterClass
    public void removeSrcDir() throws Exception {
        if (!this.needToRemoveSrcDir()) {
            return;
        }
        if (this.srcDir == null) {
            return;
        }
        AbstractDepinjectTestNg.removeRecursively(new File(this.srcDir));
    }

    private static void removeRecursively(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File subFile : files) {
                AbstractDepinjectTestNg.removeRecursively(subFile);
            }
        }
        ServerUtil.dummyCheck((boolean)file.delete());
    }

    protected boolean needToRemoveSrcDir() {
        return true;
    }

    protected String getSrcTempDir() {
        if (new File("build").isDirectory()) {
            return "build/depinject_testNg";
        }
        if (new File("target").isDirectory()) {
            return "target/depinject_testNg";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        return System.getProperty("java.io.tmpdir") + "/depinject_testNg_" + sdf.format(new Date());
    }
}

