/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.testng;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kz.greetgo.depinject.core.Bean;
import kz.greetgo.depinject.core.BeanConfig;
import kz.greetgo.depinject.core.BeanContainer;
import kz.greetgo.depinject.core.BeanScanner;
import kz.greetgo.depinject.core.Include;
import kz.greetgo.depinject.gen.BeanContainerGenerator;
import kz.greetgo.depinject.testng.AbstractDepinjectTestNg;
import kz.greetgo.depinject.testng.ContainerConfig;
import kz.greetgo.java_compiler.JavaCompiler;
import kz.greetgo.java_compiler.JavaCompilerFactory;
import kz.greetgo.util.RND;
import kz.greetgo.util.ServerUtil;

public class DepinjectTestNg {
    public static String prepareDepinjectTestNg(AbstractDepinjectTestNg testNgTest, String srcTempDir) throws Exception {
        JavaCompiler compiler = JavaCompilerFactory.createDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
        String srcDir = srcTempDir + "/" + sdf.format(new Date()) + "-" + RND.intStr((int)10);
        ArrayList classList = new ArrayList();
        Class<?> testNgTestClass = testNgTest.getClass();
        DepinjectTestNg.appendAllIncludes(classList, testNgTestClass);
        if (classList.isEmpty()) {
            return srcDir;
        }
        String outerPackage = "a" + RND.intStr((int)10) + ".";
        String containerInterface = outerPackage + testNgTestClass.getSimpleName() + "_ContainerInterface_" + RND.intStr((int)10);
        String containerInterfaceImpl = outerPackage + testNgTestClass.getSimpleName() + "_ContainerInterfaceImpl_" + RND.intStr((int)10);
        String testNgTestStaticFactory = outerPackage + testNgTestClass.getSimpleName() + "_StaticFactory_" + RND.intStr((int)10);
        String testNgTestConfig = outerPackage + testNgTestClass.getSimpleName() + "_Config_" + RND.intStr((int)10);
        File testNgTestConfigJava = DepinjectTestNg.writeTestNgTestConfig(srcDir, testNgTestConfig);
        File testNgTestStaticFactoryJava = DepinjectTestNg.writeTestNgStaticFactory(srcDir, testNgTestStaticFactory, testNgTestClass);
        File containerInterfaceJava = DepinjectTestNg.writeTestNgTestConfig(srcDir, containerInterface, testNgTestClass, testNgTestConfig, classList);
        ServerUtil.addToClasspath((String)srcDir);
        compiler.compile(testNgTestConfigJava);
        compiler.compile(containerInterfaceJava);
        compiler.compile(testNgTestStaticFactoryJava);
        BeanContainerGenerator g = new BeanContainerGenerator();
        g.beanContainerInterface = Class.forName(containerInterface);
        g.implClassName = ServerUtil.extractName((String)containerInterfaceImpl);
        g.packageName = ServerUtil.extractPackage((String)containerInterfaceImpl);
        g.writeToSourceDir(srcDir);
        File containerInterfaceImplJava = ServerUtil.resolveFile((String)srcDir, (String)containerInterfaceImpl, (String)".java");
        compiler.compile(containerInterfaceImplJava);
        Class<?> containerInterfaceImplClass = Class.forName(containerInterfaceImpl);
        Class<?> testNgTestStaticFactoryClass = Class.forName(testNgTestStaticFactory);
        testNgTestStaticFactoryClass.getField("instance").set(null, testNgTest);
        Object containerInstance = containerInterfaceImplClass.newInstance();
        containerInterfaceImplClass.getMethod("getMain", new Class[0]).invoke(containerInstance, new Object[0]);
        return srcDir;
    }

    private static File writeTestNgTestConfig(String srcDir, String containerInterface, Class<?> testNgTestClass, String testNgTestConfig, List<Class<?>> classList) throws Exception {
        File file = ServerUtil.resolveFile((String)srcDir, (String)containerInterface, (String)".java");
        ServerUtil.dummyCheck((boolean)file.getParentFile().mkdirs());
        try (PrintStream out = new PrintStream(file, "UTF-8");){
            String className = ServerUtil.extractName((String)containerInterface);
            String packageName = ServerUtil.extractPackage((String)containerInterface);
            if (packageName != null) {
                out.println("package " + packageName + ";");
            }
            out.println();
            out.println('@' + Include.class.getName() + "({" + testNgTestConfig + ".class");
            for (Class<?> aClass : classList) {
                out.println("  , " + aClass.getName() + ".class");
            }
            out.println("})");
            out.println("public interface " + className + " extends " + BeanContainer.class.getName() + " {");
            out.println("  " + testNgTestClass.getName() + " getMain();");
            out.println('}');
        }
        return file;
    }

    private static File writeTestNgStaticFactory(String srcDir, String testNgTestStaticFactory, Class<?> testNgTestClass) throws Exception {
        File file = ServerUtil.resolveFile((String)srcDir, (String)testNgTestStaticFactory, (String)".java");
        ServerUtil.dummyCheck((boolean)file.getParentFile().mkdirs());
        try (PrintStream out = new PrintStream(file, "UTF-8");){
            String className = ServerUtil.extractName((String)testNgTestStaticFactory);
            String packageName = ServerUtil.extractPackage((String)testNgTestStaticFactory);
            if (packageName != null) {
                out.println("package " + packageName + ";");
            }
            out.println();
            out.println("@" + Bean.class.getName());
            out.println("public class " + className + " {");
            out.println("  ");
            out.println("  public static " + testNgTestClass.getName() + " instance = null;");
            out.println("  ");
            out.println("  @" + Bean.class.getName());
            out.println("  public " + testNgTestClass.getName() + " getInstance() {return instance;}");
            out.println("  ");
            out.println("}");
        }
        return file;
    }

    private static File writeTestNgTestConfig(String srcDir, String testNgTestConfig) throws Exception {
        File file = ServerUtil.resolveFile((String)srcDir, (String)testNgTestConfig, (String)".java");
        ServerUtil.dummyCheck((boolean)file.getParentFile().mkdirs());
        try (PrintStream out = new PrintStream(file, "UTF-8");){
            String className = ServerUtil.extractName((String)testNgTestConfig);
            String packageName = ServerUtil.extractPackage((String)testNgTestConfig);
            if (packageName != null) {
                out.println("package " + packageName + ";");
            }
            out.println();
            out.println("@" + BeanConfig.class.getName());
            out.println("@" + BeanScanner.class.getName());
            out.println("public class " + className + " {}");
        }
        return file;
    }

    private static void appendAllIncludes(List<Class<?>> classList, Class<?> aClass) {
        if (aClass == null) {
            return;
        }
        if (aClass == Object.class) {
            return;
        }
        ContainerConfig a = aClass.getAnnotation(ContainerConfig.class);
        if (a == null) {
            DepinjectTestNg.appendAllIncludes(classList, aClass.getSuperclass());
            return;
        }
        Collections.addAll(classList, a.value());
        if (a.inherit()) {
            DepinjectTestNg.appendAllIncludes(classList, aClass.getSuperclass());
        }
    }
}

