/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import kz.greetgo.email.Email;
import kz.greetgo.email.EmailSendRegister;
import kz.greetgo.email.EmailSender;
import kz.greetgo.email.EmailSerializer;
import kz.greetgo.email.EmailSerializerXml;
import kz.greetgo.email.RealEmailSender;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public abstract class AbstractMongoEmailSendRegister
implements EmailSendRegister {
    private final Random rnd = new SecureRandom();

    protected abstract MongoCollection<Document> collection();

    protected abstract RealEmailSender realEmailSender();

    public EmailSender createEmailSaver() {
        return this::saveEmail;
    }

    private void saveEmail(Email email) {
        if (email == null) {
            return;
        }
        Document document = new Document();
        document.put("content", (Object)this.emailSerializer().serialize(email));
        document.put("insertedAt", (Object)this.now());
        this.collection().insertOne((Object)document);
        this.useJustInsertedId(document.getObjectId((Object)"_id"));
    }

    protected EmailSerializer emailSerializer() {
        return new EmailSerializerXml();
    }

    private ObjectId rndId() {
        byte[] bytes = new byte[12];
        this.rnd.nextBytes(bytes);
        return new ObjectId(bytes);
    }

    public void sendAllExistingEmails() {
        while (this.sendOne()) {
        }
    }

    private boolean sendOne() {
        ObjectId operationId = this.rndId();
        UpdateResult updateResult = this.collection().updateOne(Filters.and((Bson[])new Bson[]{Filters.exists((String)"sentOk", (boolean)false), Filters.exists((String)"operationId", (boolean)false)}), Updates.combine((Bson[])new Bson[]{Updates.set((String)"operationId", (Object)operationId), Updates.set((String)"sendStartedAt", (Object)this.now())}));
        if (updateResult.getModifiedCount() == 0L) {
            return false;
        }
        Document document = (Document)this.collection().find(Filters.eq((String)"operationId", (Object)operationId)).projection(Updates.combine((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)1), Filters.eq((String)"content", (Object)1)})).first();
        if (document == null) {
            return true;
        }
        Email email = this.emailSerializer().deserialize(document.getString((Object)"content"));
        try {
            this.realEmailSender().realSend(email);
        }
        catch (Throwable sendError) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            sendError.printStackTrace(printWriter);
            printWriter.flush();
            this.collection().updateOne(Filters.eq((String)"_id", (Object)document.getObjectId((Object)"_id")), Updates.combine((Bson[])new Bson[]{Updates.set((String)"sendErr", (Object)true), Updates.set((String)"sendErrAt", (Object)this.now()), Updates.set((String)"sendErrClass", (Object)sendError.getClass().getName()), Updates.set((String)"sendErrMessage", (Object)sendError.getMessage()), Updates.set((String)"sendErrStackTrace", (Object)strWriter.toString())}));
            this.sendError(sendError);
            return true;
        }
        this.collection().updateOne(Filters.eq((String)"_id", (Object)document.getObjectId((Object)"_id")), Updates.combine((Bson[])new Bson[]{Updates.set((String)"sentOk", (Object)true), Updates.set((String)"sendFinishedAt", (Object)this.now())}));
        return true;
    }

    protected void sendError(Throwable sendError) {
    }

    public void cleanOldSentEntries(int hoursBefore) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.now());
        calendar.add(10, -hoursBefore);
        this.collection().deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"sentOk", (Object)true), Filters.lt((String)"sendFinishedAt", (Object)calendar.getTime())}));
    }

    protected void useJustInsertedId(ObjectId justInsertedId) {
    }

    protected Date now() {
        return new Date();
    }
}

