/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email.real_send_spring;

import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import kz.greetgo.email.Attachment;
import kz.greetgo.email.Email;
import kz.greetgo.email.RealEmailSender;
import kz.greetgo.email.real_send_spring.ErrorFilters;
import kz.greetgo.email.real_send_spring.SendEmailConfig;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public abstract class AbstractRealEmailSender
implements RealEmailSender {
    protected abstract SendEmailConfig conf();

    public void realSend(Email email) {
        List<String> addressesToSend = Stream.concat(Stream.of(email.getTo()), email.getCopies().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        if (addressesToSend.isEmpty()) {
            return;
        }
        if (this.conf().useFake()) {
            this.trace(() -> "t4C8neHqM0 :: FAKE: \u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043c\u044b\u043b\u0430 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: smtpHost = " + this.conf().smtpHost() + ", smtpPort = " + this.conf().smtpPort() + ", username = " + this.conf().username() + ", addressesToSend = " + addressesToSend);
            return;
        }
        JavaMailSenderImpl mailSender = this.createJavaMailSenderImpl();
        String fromAddress = this.takeFromAddress(email);
        MimeMessage mimeMessage = this.convert(mailSender, email, addressesToSend, fromAddress);
        this.trace(() -> "Ys77B6eHZk :: \u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043c\u044b\u043b\u0430 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: smtpHost = " + this.conf().smtpHost() + ", smtpPort = " + this.conf().smtpPort() + ", username = " + this.conf().username() + ", fromAddress = " + fromAddress);
        try {
            mailSender.send(mimeMessage);
        }
        catch (MailException e) {
            ErrorFilters.mail(e).ignoreUserUnknown().check();
        }
    }

    protected JavaMailSenderImpl createJavaMailSenderImpl() {
        JavaMailSenderImpl impl = new JavaMailSenderImpl();
        impl.setHost(this.conf().smtpHost());
        impl.setPort(this.conf().smtpPort());
        impl.setUsername(this.conf().username());
        impl.setPassword(this.conf().password());
        Properties props = impl.getJavaMailProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", this.conf().smtpAuth() + "");
        props.put("mail.smtp.ssl.enable", this.conf().smtpSslEnable() + "");
        props.put("mail.smtp.starttls.enable", this.conf().smtpStartTlsEnable() + "");
        props.put("mail.mime.charset", this.conf().mimeCharset() + "");
        this.populateJavaMailProperties(props);
        return impl;
    }

    protected void populateJavaMailProperties(Properties props) {
    }

    protected void trace(Supplier<String> message) {
    }

    private String takeFromAddress(Email email) {
        String fromAddress = email.getFrom();
        if (fromAddress == null || "null".equals(fromAddress)) {
            fromAddress = this.conf().sendFrom();
        }
        if (fromAddress == null || "null".equals(fromAddress)) {
            fromAddress = "root";
        }
        if (!fromAddress.contains("@")) {
            fromAddress = fromAddress + "@" + this.defaultEmailDomain();
        }
        return fromAddress;
    }

    protected String defaultEmailDomain() {
        return "greetgo.kz";
    }

    protected MimeMessage convert(JavaMailSenderImpl mailSender, Email email, List<String> toList, String fromAddress) {
        MimeMessage ret = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(ret, "UTF-8");
        try {
            helper.setTo(toList.toArray(new String[0]));
            helper.setFrom(fromAddress);
            helper.setSubject(email.getSubject());
            helper.setText(email.getBody(), true);
            List attachments = email.getAttachments();
            for (Attachment attachment : attachments) {
                ByteArrayDataSource data = new ByteArrayDataSource(attachment.data, "text/html");
                helper.addAttachment(attachment.name, (DataSource)data);
            }
            return ret;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

