/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicBoolean;
import kz.greetgo.email.Email;
import kz.greetgo.email.EmailSender;
import kz.greetgo.email.EmailSerializer;
import kz.greetgo.email.EmailUtil;

public class EmailSenderController {
    private final AtomicBoolean sendingIsGoingOn = new AtomicBoolean(false);
    private final File toSendDir;
    private final File sentDir;
    private final EmailSender emailSender;
    private final EmailSerializer emailSerializer = new EmailSerializer();

    public EmailSenderController(EmailSender emailSender, File toSendDir, File sentDir) {
        this.emailSender = emailSender;
        this.toSendDir = toSendDir;
        this.sentDir = sentDir;
    }

    public void sendAllExistingEmails() {
        if (!this.sendingIsGoingOn.compareAndSet(false, true)) {
            return;
        }
        try {
            while (this.hasToSendOne()) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.sendingIsGoingOn.set(false);
        }
    }

    private boolean hasToSendOne() throws Exception {
        EmailInfo info = this.getFirstFromDir(this.toSendDir);
        if (info == null) {
            return false;
        }
        if (!info.file.renameTo(info.sendingFile)) {
            return true;
        }
        try {
            this.emailSender.send(info.email);
        }
        catch (Exception exception) {
            EmailUtil.dummyCheck(info.sendingFile.renameTo(info.file));
            throw exception;
        }
        EmailUtil.dummyCheck(info.sendedFile.getParentFile().mkdirs());
        EmailUtil.dummyCheck(info.sendingFile.renameTo(info.sendedFile));
        return true;
    }

    private EmailInfo getFirstFromDir(File emailSendDir) throws Exception {
        File[] files = emailSendDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".xml");
            }
        });
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            return null;
        }
        EmailInfo ret = new EmailInfo();
        ret.file = files[0];
        ret.email = this.emailSerializer.deserialize(ret.file);
        ret.sendingFile = new File(ret.file.getAbsolutePath() + ".sending");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ret.sendedFile = new File(this.sentDir + "/" + format.format(new Date()) + "/" + ret.file.getName());
        return ret;
    }

    @Deprecated
    public void cleanOldSendedFiles(int daysBefore) {
        this.cleanOldSentFiles(daysBefore);
    }

    public void cleanOldSentFiles(int daysBefore) {
        GregorianCalendar cal = new GregorianCalendar();
        Date now = new Date();
        for (File file : EmailUtil.findFilesRecursively(this.sentDir, ".xml")) {
            cal.setTimeInMillis(file.lastModified());
            ((Calendar)cal).add(6, daysBefore);
            if (!cal.getTime().before(now)) continue;
            EmailSenderController.deleteWithParents(file);
        }
    }

    private static void deleteWithParents(File file) {
        if (file.delete()) {
            EmailSenderController.deleteWithParents(file.getParentFile());
        }
    }

    private static class EmailInfo {
        File file;
        File sendingFile;
        File sendedFile;
        Email email;

        private EmailInfo() {
        }
    }
}

