/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email.from_spring;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import kz.greetgo.email.from_spring.MailMessage;

public class SimpleMailMessage
implements MailMessage,
Serializable {
    private String from;
    private String replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private Date sentDate;
    private String subject;
    private String text;

    public SimpleMailMessage() {
    }

    public SimpleMailMessage(SimpleMailMessage original) {
        this.from = original.getFrom();
        this.replyTo = original.getReplyTo();
        if (original.getTo() != null) {
            this.to = new String[original.getTo().length];
            System.arraycopy(original.getTo(), 0, this.to, 0, original.getTo().length);
        }
        if (original.getCc() != null) {
            this.cc = new String[original.getCc().length];
            System.arraycopy(original.getCc(), 0, this.cc, 0, original.getCc().length);
        }
        if (original.getBcc() != null) {
            this.bcc = new String[original.getBcc().length];
            System.arraycopy(original.getBcc(), 0, this.bcc, 0, original.getBcc().length);
        }
        this.sentDate = original.getSentDate();
        this.subject = original.getSubject();
        this.text = original.getText();
    }

    @Override
    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setTo(String to) {
        this.to = new String[]{to};
    }

    @Override
    public void setTo(String[] to) {
        this.to = to;
    }

    public String[] getTo() {
        return this.to;
    }

    @Override
    public void setCc(String cc) {
        this.cc = new String[]{cc};
    }

    @Override
    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public String[] getCc() {
        return this.cc;
    }

    @Override
    public void setBcc(String bcc) {
        this.bcc = new String[]{bcc};
    }

    @Override
    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    @Override
    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void copyTo(MailMessage target) {
        if (this.getFrom() != null) {
            target.setFrom(this.getFrom());
        }
        if (this.getReplyTo() != null) {
            target.setReplyTo(this.getReplyTo());
        }
        if (this.getTo() != null) {
            target.setTo(this.getTo());
        }
        if (this.getCc() != null) {
            target.setCc(this.getCc());
        }
        if (this.getBcc() != null) {
            target.setBcc(this.getBcc());
        }
        if (this.getSentDate() != null) {
            target.setSentDate(this.getSentDate());
        }
        if (this.getSubject() != null) {
            target.setSubject(this.getSubject());
        }
        if (this.getText() != null) {
            target.setText(this.getText());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SimpleMailMessage: ");
        sb.append("from=").append(this.from).append("; ");
        sb.append("replyTo=").append(this.replyTo).append("; ");
        sb.append("to=").append(this.arrayToCommaDelimitedString(this.to)).append("; ");
        sb.append("cc=").append(this.arrayToCommaDelimitedString(this.cc)).append("; ");
        sb.append("bcc=").append(this.arrayToCommaDelimitedString(this.bcc)).append("; ");
        sb.append("sentDate=").append(this.sentDate).append("; ");
        sb.append("subject=").append(this.subject).append("; ");
        sb.append("text=").append(this.text);
        return sb.toString();
    }

    private String arrayToCommaDelimitedString(String[] strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str).append("; ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleMailMessage)) {
            return false;
        }
        SimpleMailMessage otherMessage = (SimpleMailMessage)other;
        return Objects.equals(this.from, otherMessage.from) && Objects.equals(this.replyTo, otherMessage.replyTo) && Arrays.equals(this.to, otherMessage.to) && Arrays.equals(this.cc, otherMessage.cc) && Arrays.equals(this.bcc, otherMessage.bcc) && Objects.equals(this.sentDate, otherMessage.sentDate) && Objects.equals(this.subject, otherMessage.subject) && Objects.equals(this.text, otherMessage.text);
    }

    public int hashCode() {
        int i;
        int hashCode = this.from == null ? 0 : this.from.hashCode();
        hashCode = 29 * hashCode + (this.replyTo == null ? 0 : this.replyTo.hashCode());
        for (i = 0; this.to != null && i < this.to.length; ++i) {
            hashCode = 29 * hashCode + (this.to == null ? 0 : this.to[i].hashCode());
        }
        for (i = 0; this.cc != null && i < this.cc.length; ++i) {
            hashCode = 29 * hashCode + (this.cc == null ? 0 : this.cc[i].hashCode());
        }
        for (i = 0; this.bcc != null && i < this.bcc.length; ++i) {
            hashCode = 29 * hashCode + (this.bcc == null ? 0 : this.bcc[i].hashCode());
        }
        hashCode = 29 * hashCode + (this.sentDate == null ? 0 : this.sentDate.hashCode());
        hashCode = 29 * hashCode + (this.subject == null ? 0 : this.subject.hashCode());
        hashCode = 29 * hashCode + (this.text == null ? 0 : this.text.hashCode());
        return hashCode;
    }
}

