/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email.from_spring.javamail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import kz.greetgo.email.from_spring.javamail.ClassPathResource;
import kz.greetgo.email.from_spring.javamail.Resource;

public class ConfigurableMimeFileTypeMap
extends FileTypeMap {
    private Resource mappingLocation = new ClassPathResource("mime.types", ((Object)((Object)this)).getClass());
    private String[] mappings;
    private FileTypeMap fileTypeMap;

    public void setMappingLocation(Resource mappingLocation) {
        this.mappingLocation = mappingLocation;
    }

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void afterPropertiesSet() {
        this.getFileTypeMap();
    }

    protected final FileTypeMap getFileTypeMap() {
        if (this.fileTypeMap == null) {
            try {
                this.fileTypeMap = this.createFileTypeMap(this.mappingLocation, this.mappings);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not load specified MIME type mapping file: " + this.mappingLocation);
            }
        }
        return this.fileTypeMap;
    }

    protected FileTypeMap createFileTypeMap(Resource mappingLocation, String[] mappings) throws IOException {
        MimetypesFileTypeMap fileTypeMap;
        if (mappingLocation == null) {
            fileTypeMap = new MimetypesFileTypeMap();
        } else {
            InputStream inputStream = mappingLocation.getInputStream();
            if (inputStream == null) {
                throw new NullPointerException("mappingLocation.getInputStream() == null");
            }
            fileTypeMap = new MimetypesFileTypeMap(inputStream);
        }
        if (mappings != null) {
            for (String mapping : mappings) {
                fileTypeMap.addMimeTypes(mapping);
            }
        }
        return fileTypeMap;
    }

    public String getContentType(File file) {
        return this.getFileTypeMap().getContentType(file);
    }

    public String getContentType(String fileName) {
        return this.getFileTypeMap().getContentType(fileName);
    }
}

