/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import kz.greetgo.email.Email;
import kz.greetgo.email.EmailSender;
import kz.greetgo.email.EmailSerializer;
import kz.greetgo.email.EmailUtil;

public class EmailSaver
implements EmailSender {
    private final String sendDir;
    private final String filePrefixName;
    private final Random rnd = new Random();

    public EmailSaver(String filePrefixName, String sendDir) {
        this.filePrefixName = filePrefixName;
        this.sendDir = sendDir;
    }

    @Override
    public void send(Email email) {
        String filename = this.createFileName();
        File file = new File(this.sendDir + "/" + filename + ".creating");
        EmailUtil.dummyCheck(file.getParentFile().mkdirs());
        EmailSerializer emailSerializer = new EmailSerializer();
        try {
            emailSerializer.serialize(file, email);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EmailUtil.dummyCheck(file.renameTo(new File(this.sendDir + "/" + filename)));
    }

    private String createFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
        return this.filePrefixName + '-' + format.format(new Date()) + '.' + this.rnd.nextInt() + ".email.xml";
    }
}

