/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import kz.greetgo.email.Email;
import kz.greetgo.email.EmailSender;
import kz.greetgo.email.EmailSerializer;
import kz.greetgo.email.EmailUtil;

public class EmailSenderController {
    private boolean inSendOperation = false;
    private final File sendDir;
    private final File sendedDir;
    private final EmailSender emailSender;
    private final EmailSerializer emailSerializer = new EmailSerializer();

    public EmailSenderController(EmailSender emailSender, File sendDir, File sendedDir) {
        this.emailSender = emailSender;
        this.sendDir = sendDir;
        this.sendedDir = sendedDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAllExistingEmails() {
        EmailSenderController emailSenderController = this;
        synchronized (emailSenderController) {
            if (this.inSendOperation) {
                return;
            }
            this.inSendOperation = true;
        }
        try {
            while (this.hasToSendOne()) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            EmailSenderController emailSenderController2 = this;
            synchronized (emailSenderController2) {
                this.inSendOperation = false;
            }
        }
    }

    private boolean hasToSendOne() throws Exception {
        EmailInfo info = this.getFirstFromDir(this.sendDir);
        if (info == null) {
            return false;
        }
        EmailUtil.dummyCheck(info.file.renameTo(info.sendingFile));
        try {
            this.emailSender.send(info.email);
        }
        catch (Exception exception) {
            EmailUtil.dummyCheck(info.sendingFile.renameTo(info.file));
            throw exception;
        }
        EmailUtil.dummyCheck(info.sendedFile.getParentFile().mkdirs());
        EmailUtil.dummyCheck(info.sendingFile.renameTo(info.sendedFile));
        return true;
    }

    private EmailInfo getFirstFromDir(File emailSendDir) throws Exception {
        File[] files = emailSendDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".xml");
            }
        });
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            return null;
        }
        EmailInfo ret = new EmailInfo();
        ret.file = files[0];
        ret.email = this.emailSerializer.deserialize(ret.file);
        ret.sendingFile = new File(ret.file.getAbsolutePath() + ".sending");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ret.sendedFile = new File(this.sendedDir + "/" + format.format(new Date()) + "/" + ret.file.getName());
        return ret;
    }

    public void cleanOldSendedFiles(final int daysBefore) {
        final GregorianCalendar cal = new GregorianCalendar();
        final Date now = new Date();
        File[] files = this.sendedDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                if (!pathname.getName().endsWith(".xml")) {
                    return false;
                }
                cal.setTimeInMillis(pathname.lastModified());
                cal.add(6, daysBefore);
                return cal.getTime().before(now);
            }
        });
        if (files == null) {
            return;
        }
        if (files.length == 0) {
            return;
        }
        for (File file : files) {
            EmailUtil.dummyCheck(file.delete());
        }
    }

    private static class EmailInfo {
        File file;
        File sendingFile;
        File sendedFile;
        Email email;

        private EmailInfo() {
        }
    }
}

