/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Base64;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kz.greetgo.email.Attachment;
import kz.greetgo.email.Email;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class EmailSerializer {
    private SAXParser parser;

    public void serialize(PrintStream out, Email email) {
        out.println("<?xml version='1.0' encoding='UTF-8' ?>");
        out.println("<letter>");
        EmailSerializer.printTag(out, "to", email.getTo());
        for (String copy : email.getCopies()) {
            EmailSerializer.printTag(out, "copy", copy);
        }
        EmailSerializer.printTag(out, "from", email.getFrom());
        EmailSerializer.printTag(out, "subject", email.getSubject());
        EmailSerializer.printTag(out, "body", email.getBody());
        if (!email.getAttachments().isEmpty()) {
            this.printAttachments(out, email.getAttachments());
        }
        out.println("</letter>");
    }

    private void printAttachments(PrintStream out, List<Attachment> attachments) {
        out.println();
        for (Attachment attachment : attachments) {
            this.printAttachment(out, attachment);
        }
    }

    private void printAttachment(PrintStream out, Attachment attachment) {
        if (attachment == null) {
            return;
        }
        if (attachment.data == null) {
            return;
        }
        out.print("\t<attachment name=\"" + attachment.name + "\">");
        out.print(Base64.getEncoder().encodeToString(attachment.data));
        out.println("</attachment>");
    }

    public void serialize(File file, Email email) throws Exception {
        PrintStream out = new PrintStream(file, "UTF-8");
        this.serialize(out, email);
        out.close();
    }

    public void serialize(OutputStream outStream, Email email) throws Exception {
        PrintStream out = new PrintStream(outStream, false, "UTF-8");
        this.serialize(out, email);
        out.flush();
    }

    private static void printTag(PrintStream out, String tagName, String content) {
        out.print("\t<");
        out.print(tagName);
        out.print("><![CDATA[");
        out.print(content);
        out.print("]]></");
        out.print(tagName);
        out.println('>');
    }

    private SAXParser parser() throws Exception {
        if (this.parser == null) {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        return this.parser;
    }

    public Email deserialize(InputStream bin) throws Exception {
        ParseHandler handler = new ParseHandler();
        this.parser().parse(bin, (DefaultHandler)handler);
        return handler.target;
    }

    public Email deserialize(File file) throws Exception {
        try (FileInputStream fin = new FileInputStream(file);){
            Email email = this.deserialize(fin);
            return email;
        }
    }

    private static class ParseHandler
    extends DefaultHandler {
        final Email target = new Email();
        StringBuilder text = null;
        Attachment attachment = null;

        private ParseHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.text == null) {
                this.text = new StringBuilder();
            }
            this.text.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.text = null;
            if ("attachment".equals(qName)) {
                this.attachment = new Attachment();
                this.attachment.name = attributes.getValue("name");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("to".equals(qName)) {
                this.target.setTo(this.text.toString());
                return;
            }
            if ("copy".equals(qName)) {
                this.target.getCopies().add(this.text.toString());
                return;
            }
            if ("from".equals(qName)) {
                this.target.setFrom(this.text.toString());
                return;
            }
            if ("body".equals(qName)) {
                this.target.setBody(this.text.toString());
                return;
            }
            if ("subject".equals(qName)) {
                this.target.setSubject(this.text.toString());
                return;
            }
            if ("attachment".equals(qName) && this.attachment != null) {
                this.attachment.data = Base64.getDecoder().decode(this.text.toString());
                this.target.getAttachments().add(this.attachment);
                this.attachment = null;
            }
        }
    }
}

