/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.email;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kz.greetgo.email.Attachment;
import kz.greetgo.email.Email;
import kz.greetgo.email.EmailSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EmailSerializerXml
implements EmailSerializer {
    @Override
    public String serialize(Email email) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element letter = document.createElement("letter");
            document.appendChild(letter);
            this.addTag(document, letter, "subject", email.getSubject());
            this.addTag(document, letter, "to", email.getTo());
            for (String copy : email.getCopies()) {
                this.addTag(document, letter, "copy", copy);
            }
            this.addTag(document, letter, "from", email.getFrom());
            this.addTag(document, letter, "body", email.getBody());
            if (email.getName() != null) {
                this.addTag(document, letter, "name", email.getName());
            }
            for (Attachment attachment : email.getAttachments()) {
                this.addAttachment(document, letter, attachment);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
            return stringWriter.toString();
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void addAttachment(Document document, Element letter, Attachment attachment) {
        Element element = document.createElement("attachment");
        letter.appendChild(element);
        element.setAttribute("name", attachment.name);
        element.setTextContent(Base64.getEncoder().encodeToString(attachment.data));
    }

    private void addTag(Document document, Element letter, String tagName, String tagContent) {
        Element element = document.createElement(tagName);
        letter.appendChild(element);
        element.setTextContent(tagContent);
    }

    @Override
    public void serialize(PrintStream out, Email email) {
        out.println(this.serialize(email));
    }

    @Override
    public void serialize(File file, Email email) {
        try (PrintStream out = new PrintStream(file, "UTF-8");){
            this.serialize(out, email);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void serialize(OutputStream outStream, Email email) {
        try (PrintStream out = new PrintStream(outStream, false, "UTF-8");){
            this.serialize(out, email);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SAXParser parser() throws ParserConfigurationException, SAXException {
        return SAXParserFactory.newInstance().newSAXParser();
    }

    @Override
    public Email deserialize(InputStream bin) {
        ParseHandler handler = new ParseHandler();
        try {
            this.parser().parse(bin, (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        return handler.target;
    }

    @Override
    public Email deserialize(String xmlString) {
        ParseHandler handler = new ParseHandler();
        try {
            this.parser().parse((InputStream)new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        return handler.target;
    }

    @Override
    public Email deserialize(File file) {
        Email email;
        FileInputStream fin = new FileInputStream(file);
        try {
            email = this.deserialize(fin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        fin.close();
        return email;
    }

    private static class ParseHandler
    extends DefaultHandler {
        final Email target = new Email();
        StringBuilder text = null;
        Attachment attachment = null;

        private ParseHandler() {
        }

        private String text() {
            StringBuilder x = this.text;
            return x == null ? null : x.toString();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.text == null) {
                this.text = new StringBuilder();
            }
            this.text.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.text = null;
            if ("attachment".equals(qName)) {
                this.attachment = new Attachment();
                this.attachment.name = attributes.getValue("name");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("to".equals(qName)) {
                this.target.setTo(this.text());
                return;
            }
            if ("copy".equals(qName)) {
                this.target.getCopies().add(this.text());
                return;
            }
            if ("from".equals(qName)) {
                this.target.setFrom(this.text());
                return;
            }
            if ("body".equals(qName)) {
                this.target.setBody(this.text());
                return;
            }
            if ("subject".equals(qName)) {
                this.target.setSubject(this.text());
                return;
            }
            if ("name".equals(qName)) {
                this.target.setName(this.text());
                return;
            }
            if ("attachment".equals(qName) && this.attachment != null) {
                this.attachment.data = Base64.getDecoder().decode(this.text());
                this.target.getAttachments().add(this.attachment);
                this.attachment = null;
            }
        }
    }
}

