/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kz.greetgo.msoffice.LeftFileException;

public class UtilOffice {
    public static final SimpleDateFormat W3CDTF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final int MILLIS_IN_DAY = 86400000;
    private static final String[] LETTER_BASE = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int EXCEL_DATE_MAGIC = 25600;

    public static String toW3CDTF(Date date) {
        if (date == null) {
            return null;
        }
        return W3CDTF.format(date);
    }

    public static Date parseW3CDTF(String str) {
        if (str == null) {
            return null;
        }
        try {
            return W3CDTF.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toLenZero(int len, String s) {
        if (s == null) {
            s = "";
        }
        while (len > s.length()) {
            s = "0" + s;
        }
        return s;
    }

    public static String toHEX(Color color) {
        if (color == null) {
            return "";
        }
        return UtilOffice.toLenZero(2, Integer.toHexString(color.getRed()).toUpperCase()) + UtilOffice.toLenZero(2, Integer.toHexString(color.getGreen()).toUpperCase()) + UtilOffice.toLenZero(2, Integer.toHexString(color.getBlue()).toUpperCase());
    }

    public static void appendToSB(InputStream in, StringBuilder sb) {
        try {
            UtilOffice.appendToSB0(in, sb);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendToSB0(InputStream in, StringBuilder sb) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append(System.getProperty("line.separator"));
        }
        br.close();
    }

    public static String streamToStr(InputStream in) {
        StringBuilder sb = new StringBuilder();
        UtilOffice.appendToSB(in, sb);
        return sb.toString();
    }

    public static String streamToStr0(InputStream in) throws Exception {
        StringBuilder sb = new StringBuilder();
        UtilOffice.appendToSB0(in, sb);
        return sb.toString();
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int readBytes;
        byte[] buffer = new byte[bufferSize];
        while ((readBytes = in.read(buffer)) != -1) {
            out.write(buffer, 0, readBytes);
        }
    }

    public static void copyStreams(InputStream in, OutputStream out) throws IOException {
        UtilOffice.copyStreams(in, out, 2048);
    }

    public static String killFirstSlash(String s) {
        if (s == null) {
            return null;
        }
        if (!s.startsWith("/")) {
            return s;
        }
        return s.substring(1);
    }

    public static String extractBaseName(String fullName) {
        int index;
        if (fullName.endsWith("/")) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        if ((index = fullName.lastIndexOf(47)) < 0) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static boolean removeDir(String dir) {
        UtilOffice.cleanDir(dir);
        return new File(dir).delete();
    }

    public static boolean cleanDir(String dir) {
        String[] subnames = new File(dir).list();
        if (subnames == null) {
            return false;
        }
        boolean ret = false;
        for (String name : subnames) {
            boolean q;
            if (".".equals(name) || "..".equals(name)) continue;
            File f = new File(dir + System.getProperty("file.separator") + name);
            if (f.isFile()) {
                q = f.delete();
                ret = ret || q;
                continue;
            }
            if (f.isDirectory()) {
                q = UtilOffice.removeDir(f.getPath());
                ret = ret || q;
                continue;
            }
            throw new LeftFileException("Left file " + f);
        }
        return ret;
    }

    public static String toLettersNumber(int n) {
        StringBuilder ret = new StringBuilder();
        UtilOffice.appendLettersNumber(ret, n);
        return ret.toString();
    }

    public static void appendLettersNumber(StringBuilder sb, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        int base = LETTER_BASE.length;
        sb.append(LETTER_BASE[n % base]);
        n /= base;
        while (n > 0) {
            sb.insert(0, LETTER_BASE[(n - 1) % base]);
            n /= base + 1;
        }
    }

    public static int parseLettersNumber(String s) {
        if (s == null) {
            throw new NullPointerException("parseLettersNumber cannot parse null string");
        }
        if ((s = s.toUpperCase()).length() == 0) {
            throw new IllegalArgumentException("parseLettersNumber cannot parse empty string");
        }
        int ret = s.charAt(0) - 65;
        int C = s.length();
        for (int i = 1; i < C; ++i) {
            int current = s.charAt(i) - 65;
            ret = 26 * (ret + 1) + current;
        }
        return ret;
    }

    public static int[] parseCellCoord(String coord) {
        int i;
        if (coord == null) {
            throw new NullPointerException("\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        if ((coord = coord.trim()).length() < 1) {
            throw new IllegalArgumentException("\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        int[] coordint = new int[2];
        coord = coord.toUpperCase();
        for (i = 0; i < coord.length() && !Character.isDigit(coord.charAt(i)); ++i) {
        }
        String col = coord.substring(0, i);
        String row = "0";
        if (i < coord.length()) {
            row = coord.substring(i);
        }
        coordint[0] = UtilOffice.parseLettersNumber(col) + 1;
        coordint[1] = Integer.parseInt(row);
        return coordint;
    }

    public static InputStream copy(final InputStream in) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return in.read();
            }
        };
    }

    public static final Calendar epochStart() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, 1970);
        c.set(2, 1);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }

    public static Date excelToDate(String excelValue) {
        if (excelValue == null) {
            return null;
        }
        Calendar c = UtilOffice.epochStart();
        BigDecimal value = new BigDecimal(excelValue);
        c.add(6, value.setScale(0, 1).intValueExact() - 25600);
        BigDecimal afterZero = value.subtract(value.setScale(0, 1));
        BigDecimal millis = afterZero.multiply(new BigDecimal(86400000));
        millis = millis.setScale(0, 4);
        return new Date(c.getTimeInMillis() + millis.longValueExact());
    }

    public static String toExcelDateTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = UtilOffice.epochStart();
        long totalMillis = date.getTime() - c.getTimeInMillis();
        int days = (int)(totalMillis / 86400000L) + 25600;
        c.add(6, days - 25600);
        int millis = (int)(date.getTime() - c.getTimeInMillis());
        BigDecimal afterZero = new BigDecimal(millis).divide(new BigDecimal(86400000), MathContext.DECIMAL64);
        BigDecimal bdDays = new BigDecimal(days);
        BigDecimal result = bdDays.add(afterZero);
        return result.toString();
    }

    public static int charAsHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Unknown hex digit " + c + " (code is " + c + ")");
    }

    public static int parsePartAsHex(String hex, int index, int count) {
        int ret = 0;
        int base = 1;
        while (count-- > 0) {
            ret += base * UtilOffice.charAsHex(hex.charAt(index + count));
            base *= 16;
        }
        return ret;
    }

    public static String toTablePosition(int row, int col) {
        return UtilOffice.toLettersNumber(col) + row;
    }

    public static void zipDir(String dir, OutputStream out) {
        try {
            UtilOffice.zipDirEx(dir, out);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void zipDirEx(String dir, OutputStream out) throws Exception {
        ZipOutputStream zout = out instanceof ZipOutputStream ? (ZipOutputStream)out : new ZipOutputStream(out);
        UtilOffice.appendDir(dir, "", zout);
        zout.close();
    }

    private static void appendDir(String dir, String localPath, ZipOutputStream zout) throws Exception {
        for (String localName : new File(dir).list()) {
            String fullName = dir + "/" + localName;
            String localFullName = localName;
            if (localPath.length() > 0) {
                localFullName = localPath + "/" + localName;
            }
            if (new File(fullName).isDirectory()) {
                UtilOffice.appendDir(fullName, localFullName, zout);
                continue;
            }
            UtilOffice.appendFile(fullName, localFullName, zout);
        }
    }

    private static void appendFile(String fullName, String localFullName, ZipOutputStream zout) throws Exception {
        zout.putNextEntry(new ZipEntry(localFullName));
        FileInputStream in = new FileInputStream(fullName);
        UtilOffice.copyStreams(in, zout);
        in.close();
        zout.closeEntry();
    }
}

