/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.docx.FlowElement;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.Para;
import kz.greetgo.msoffice.docx.ReferencableContentElement;
import kz.greetgo.msoffice.docx.Reference;
import kz.greetgo.msoffice.docx.Table;

public abstract class DocumentFlow
implements ReferencableContentElement {
    private List<FlowElement> elements = new ArrayList<FlowElement>();
    private final MSHelper msHelper;
    private final String partName;
    private List<Reference> references = new ArrayList<Reference>();

    @Override
    public String getPartName() {
        return this.partName;
    }

    public DocumentFlow(String partName, MSHelper msHelper) {
        this.partName = partName;
        this.msHelper = msHelper;
    }

    public Para createPara() {
        return this.createPara(null);
    }

    public Para createPara(Para example) {
        Para ret = new Para(this.partName, this.msHelper);
        if (example != null) {
            ret.copyDecorationFrom(example);
        } else {
            Para defaultPara = this.msHelper.getDefaultPara();
            if (defaultPara != null) {
                ret.copyDecorationFrom(defaultPara);
            }
        }
        this.elements.add(ret);
        return ret;
    }

    public Table createTable() {
        Table ret = new Table(this.partName, this.msHelper);
        this.elements.add(ret);
        return ret;
    }

    @Override
    public void write(PrintStream out) {
        this.writeTopXml(out);
        this.writeFlow(out);
        this.writeBottomXml(out);
    }

    private void writeFlow(PrintStream out) {
        for (FlowElement e : this.elements) {
            e.write(out);
        }
    }

    @Override
    public void writeReferences(PrintStream out) {
        for (Reference r : this.references) {
            r.write(out);
        }
    }

    @Override
    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    protected abstract void writeBottomXml(PrintStream var1);

    protected abstract void writeTopXml(PrintStream var1);

    protected MSHelper getMsHelper() {
        return this.msHelper;
    }

    public Para createExamplePara(Para anotherExample) {
        Para dp;
        Para ret = new Para("", null);
        if (anotherExample != null) {
            ret.copyDecorationFrom(anotherExample);
        } else if (this.msHelper != null && (dp = this.msHelper.getDefaultPara()) != null) {
            ret.copyDecorationFrom(dp);
        }
        return ret;
    }
}

