/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.UtilOffice;
import kz.greetgo.msoffice.docx.FieldAppender;
import kz.greetgo.msoffice.docx.Font;
import kz.greetgo.msoffice.docx.Highlight;
import kz.greetgo.msoffice.docx.ImageElement;
import kz.greetgo.msoffice.docx.InputSource;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.PageBreak;
import kz.greetgo.msoffice.docx.Relationship;
import kz.greetgo.msoffice.docx.RunBr;
import kz.greetgo.msoffice.docx.RunElement;
import kz.greetgo.msoffice.docx.RunTab;
import kz.greetgo.msoffice.docx.RunText;
import kz.greetgo.msoffice.docx.TextVertAlign;
import kz.greetgo.msoffice.docx.Underline;
import kz.greetgo.msoffice.docx.XmlWriter;

public class Run
implements XmlWriter {
    private List<RunElement> elements = new ArrayList<RunElement>();
    private boolean bold = false;
    private boolean italic = false;
    private Underline underline = Underline.NONE;
    private TextVertAlign textVertAlign = TextVertAlign.NORMAL;
    private Highlight highlight = Highlight.NONE;
    private Color color = null;
    private Integer textSize;
    private final String ownerPartName;
    private final MSHelper msHelper;
    Font font;
    private FieldAppender fieldAppender = null;

    Run(String ownerPartName, MSHelper msHelper) {
        this.ownerPartName = ownerPartName;
        this.msHelper = msHelper;
    }

    public ImageElement createImage(InputSource inputSource) {
        Relationship r = this.msHelper.createRelationshipForImage(this.ownerPartName, inputSource);
        ImageElement ret = new ImageElement(r.getId());
        this.elements.add(ret);
        return ret;
    }

    @Override
    public void write(PrintStream out) {
        out.print("<w:r>");
        ArrayList<String> options = new ArrayList<String>();
        if (this.isBold()) {
            options.add("<w:b />");
        }
        if (this.isItalic()) {
            options.add("<w:i />");
        }
        if (this.getUnderline() != null && this.getUnderline() != Underline.NONE) {
            options.add("<w:u w:val=\"" + this.getUnderline().getCode() + "\" />");
        }
        if (this.getTextVertAlign() != null && this.getTextVertAlign() != TextVertAlign.NORMAL) {
            options.add("<w:vertAlign w:val=\"" + this.getTextVertAlign().getCode() + "\" />");
        }
        if (this.getHighlight() != null && this.getHighlight() != Highlight.NONE) {
            options.add("<w:highlight w:val=\"" + this.getHighlight().getCode() + "\" />");
        }
        if (this.getColor() != null) {
            options.add("<w:color w:val=\"" + UtilOffice.toHEX(this.getColor()) + "\" />");
        }
        if (this.getTextSize() != null) {
            options.add("<w:sz w:val=\"" + this.getTextSize() + "\" />");
            options.add("<w:szCs w:val=\"" + this.getTextSize() + "\" />");
        }
        if (options.size() > 0 || this.getFont() != null) {
            out.print("<w:rPr>");
            for (String s : options) {
                out.print(s);
            }
            if (this.getFont() != null) {
                this.getFont().write(out);
            }
            out.print("</w:rPr>");
        }
        for (RunElement e : this.elements) {
            e.write(out);
        }
        out.print("</w:r>");
    }

    public void addText(String text) {
        this.elements.add(new RunText(text));
    }

    public void addTab() {
        this.elements.add(new RunTab());
    }

    public void addBr() {
        this.elements.add(new RunBr());
    }

    public void addPageBreak() {
        this.elements.add(new PageBreak());
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setUnderline(Underline underline) {
        this.underline = underline;
    }

    public Underline getUnderline() {
        return this.underline;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setTextVertAlign(TextVertAlign textVertAlign) {
        this.textVertAlign = textVertAlign;
    }

    public TextVertAlign getTextVertAlign() {
        return this.textVertAlign;
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight;
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setTextSize(Integer textSize) {
        this.textSize = textSize;
    }

    public Integer getTextSize() {
        return this.textSize;
    }

    public void setFontName(String name) {
        if (name == null) {
            this.font = null;
            return;
        }
        this.font = this.msHelper.getFont(name);
    }

    public Font getFont() {
        return this.font;
    }

    public FieldAppender field() {
        if (this.fieldAppender == null) {
            this.fieldAppender = new FieldAppender(this.elements);
        }
        return this.fieldAppender;
    }
}

