/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import kz.greetgo.msoffice.xlsx.gen.BorderStyle;
import kz.greetgo.msoffice.xlsx.gen.Color;

public class Border {
    private BorderStyle style;
    private Color color;

    public Border() {
    }

    public Border(Border x) {
        this.style = x.style;
        this.color = Color.copy(x.color);
    }

    public static Border copy(Border x) {
        if (x == null) {
            return null;
        }
        return new Border(x);
    }

    public BorderStyle getStyle() {
        return this.style;
    }

    public void setStyle(BorderStyle style) {
        this.style = style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Border other = (Border)obj;
        if (this.style != other.style) {
            return false;
        }
        if (this.style == null && other.style == null) {
            return true;
        }
        return !(this.color == null ? other.color != null : !this.color.equals(other.color));
    }

    public void print(PrintStream out, String tagName) {
        if (this.style == null) {
            out.println("<" + tagName + " />");
            return;
        }
        out.print('<');
        out.print(tagName);
        out.println(" style=\"" + this.style.str() + "\">");
        if (this.color == null) {
            out.println("<color auto=\"1\" />");
        } else {
            out.println("<color rgb=\"" + this.color.str() + "\" />");
        }
        out.println("</" + tagName + ">");
    }

    public Border noStyle() {
        this.style = null;
        return this;
    }

    public Border noColor() {
        this.color = null;
        return this;
    }

    public Border clean() {
        this.style = null;
        this.color = null;
        return this;
    }

    public Border medium() {
        this.style = BorderStyle.medium;
        return this;
    }

    public Border thin() {
        this.style = BorderStyle.thin;
        return this;
    }

    public Border thick() {
        this.style = BorderStyle.thick;
        return this;
    }

    public Border style(BorderStyle style) {
        this.style = style;
        return this;
    }
}

