/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import kz.greetgo.msoffice.xlsx.gen.Border;

public class Borders {
    private final Border left;
    private final Border right;
    private final Border top;
    private final Border bottom;
    private final Border diagonal;
    private boolean diagonalUp;
    private boolean diagonalDown;

    public Borders() {
        this.left = new Border();
        this.right = new Border();
        this.top = new Border();
        this.bottom = new Border();
        this.diagonal = new Border();
        this.diagonalUp = false;
        this.diagonalDown = false;
    }

    public void clean() {
        this.diagonalUp = false;
        this.diagonalDown = false;
        this.left.clean();
        this.right.clean();
        this.top.clean();
        this.bottom.clean();
        this.diagonal.clean();
    }

    public Borders(Borders x) {
        this.left = Border.copy(x.left);
        this.right = Border.copy(x.right);
        this.top = Border.copy(x.top);
        this.bottom = Border.copy(x.bottom);
        this.diagonal = Border.copy(x.diagonal);
        this.diagonalUp = x.diagonalUp;
        this.diagonalDown = x.diagonalDown;
    }

    public static Borders copy(Borders borders) {
        if (borders == null) {
            return null;
        }
        return new Borders(borders);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bottom == null ? 0 : this.bottom.hashCode());
        result = 31 * result + (this.diagonal == null ? 0 : this.diagonal.hashCode());
        result = 31 * result + (this.diagonalDown ? 1231 : 1237);
        result = 31 * result + (this.diagonalUp ? 1231 : 1237);
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.top == null ? 0 : this.top.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Borders other = (Borders)obj;
        if (this.bottom == null ? other.bottom != null : !this.bottom.equals(other.bottom)) {
            return false;
        }
        if (this.diagonal == null ? other.diagonal != null : !this.diagonal.equals(other.diagonal)) {
            return false;
        }
        if (this.diagonalDown != other.diagonalDown) {
            return false;
        }
        if (this.diagonalUp != other.diagonalUp) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.right == null ? other.right != null : !this.right.equals(other.right)) {
            return false;
        }
        return !(this.top == null ? other.top != null : !this.top.equals(other.top));
    }

    public Border left() {
        return this.left;
    }

    public Border right() {
        return this.right;
    }

    public Border top() {
        return this.top;
    }

    public Border bottom() {
        return this.bottom;
    }

    public Border diagonal() {
        return this.diagonal;
    }

    public boolean isDiagonalUp() {
        return this.diagonalUp;
    }

    public Borders diagonalUp() {
        this.diagonalUp = true;
        return this;
    }

    public Borders noDiagonalUp() {
        this.diagonalUp = false;
        return this;
    }

    public void setDiagonalUp(boolean diagonalUp) {
        this.diagonalUp = diagonalUp;
    }

    public boolean isDiagonalDown() {
        return this.diagonalDown;
    }

    public Borders diagonalDown() {
        this.diagonalDown = true;
        return this;
    }

    public Borders noDiagonalDown() {
        this.diagonalDown = false;
        return this;
    }

    public void setDiagonalDown(boolean diagonalDown) {
        this.diagonalDown = diagonalDown;
    }

    public void medium() {
        this.top.medium();
        this.right.medium();
        this.bottom.medium();
        this.left.medium();
    }

    public void thin() {
        this.top.thin();
        this.right.thin();
        this.bottom.thin();
        this.left.thin();
    }

    public void thick() {
        this.top.thick();
        this.right.thick();
        this.bottom.thick();
        this.left.thick();
    }

    public void print(PrintStream out) {
        out.print("<border");
        if (this.diagonalUp && this.diagonal != null) {
            out.print(" diagonalUp=\"1\"");
        }
        if (this.diagonalDown && this.diagonal != null) {
            out.print(" diagonalDown=\"1\"");
        }
        out.println(">");
        if (this.left == null) {
            out.print("<left />");
        } else {
            this.left.print(out, "left");
        }
        if (this.right == null) {
            out.print("<right />");
        } else {
            this.right.print(out, "right");
        }
        if (this.top == null) {
            out.print("<top />");
        } else {
            this.top.print(out, "top");
        }
        if (this.bottom == null) {
            out.print("<bottom />");
        } else {
            this.bottom.print(out, "bottom");
        }
        if (this.diagonal == null) {
            out.print("<diagonal />");
        } else {
            this.diagonal.print(out, "diagonal");
        }
        out.print("</border>");
    }
}

