/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import kz.greetgo.msoffice.xlsx.gen.Color;
import kz.greetgo.msoffice.xlsx.gen.Fill;
import kz.greetgo.msoffice.xlsx.gen.PatternFillType;

public class PatternFill
extends Fill {
    private PatternFillType type = PatternFillType.none;
    private Color fgColor;
    private Color bgColor;

    public PatternFill() {
    }

    public PatternFill(PatternFillType type) {
        this.type = type;
    }

    public PatternFill(PatternFill x) {
        this.type = x.type;
        this.fgColor = Color.copy(x.fgColor);
        this.bgColor = Color.copy(x.bgColor);
    }

    public PatternFill none() {
        this.type = PatternFillType.none;
        this.fgColor = null;
        this.bgColor = null;
        return this;
    }

    public PatternFill solid() {
        this.type = PatternFillType.solid;
        return this;
    }

    public PatternFill type(PatternFillType type) {
        this.type = type;
        return this;
    }

    @Override
    Fill copy() {
        return new PatternFill(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bgColor == null ? 0 : this.bgColor.hashCode());
        result = 31 * result + (this.fgColor == null ? 0 : this.fgColor.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternFill other = (PatternFill)obj;
        if (this.bgColor == null ? other.bgColor != null : !this.bgColor.equals(other.bgColor)) {
            return false;
        }
        if (this.fgColor == null ? other.fgColor != null : !this.fgColor.equals(other.fgColor)) {
            return false;
        }
        return this.type == other.type;
    }

    public PatternFillType getType() {
        return this.type;
    }

    public void setType(PatternFillType type) {
        this.type = type;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public PatternFill fgColor(Color fgColor) {
        this.setFgColor(fgColor);
        return this;
    }

    public PatternFill bgColor(Color bgColor) {
        this.setBgColor(bgColor);
        return this;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    @Override
    void print(PrintStream out) {
        if (this.fgColor == null && this.bgColor == null) {
            out.println("<fill>");
            out.println("<patternFill patternType=\"" + this.type.name() + "\" />");
            out.println("</fill>");
            return;
        }
        out.println("<fill>");
        out.println("<patternFill patternType=\"" + this.type.name() + "\" >");
        if (this.fgColor != null) {
            out.println("<fgColor rgb=\"" + this.fgColor.str() + "\" />");
        }
        if (this.bgColor != null) {
            out.println("<bgColor rgb=\"" + this.bgColor.str() + "\" />");
        }
        out.println("</patternFill>");
        out.println("</fill>");
    }
}

