/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import kz.greetgo.msoffice.ImageType;
import kz.greetgo.msoffice.UtilOffice;
import kz.greetgo.msoffice.xlsx.gen.Chart;
import kz.greetgo.msoffice.xlsx.gen.ChartType;
import kz.greetgo.msoffice.xlsx.gen.Image;
import kz.greetgo.msoffice.xlsx.gen.MergeCells;
import kz.greetgo.msoffice.xlsx.gen.NumFmt;
import kz.greetgo.msoffice.xlsx.gen.PageMargins;
import kz.greetgo.msoffice.xlsx.gen.PageSetup;
import kz.greetgo.msoffice.xlsx.gen.SheetCoord;
import kz.greetgo.msoffice.xlsx.gen.Style;
import kz.greetgo.msoffice.xlsx.gen.Styles;
import kz.greetgo.msoffice.xlsx.gen.TwoCellAnchor;
import kz.greetgo.msoffice.xlsx.gen.TwoCellAnchorChart;
import kz.greetgo.msoffice.xlsx.gen.TwoCellAnchorImage;
import kz.greetgo.msoffice.xlsx.gen.Xlsx;
import kz.greetgo.msoffice.xlsx.parse.SharedStrings;

public class Sheet {
    private final Xlsx parent;
    private final Style style;
    private final String name;
    private final String workDir;
    private final SharedStrings strs;
    private double defaultRowHeight = 15.0;
    private boolean summaryBelow = true;
    private boolean summaryRight = true;
    private int curRow = 0;
    private boolean inRow = false;
    private final Map<Integer, Double> widths = new HashMap<Integer, Double>();
    private final Set<Integer> colhiddens = new HashSet<Integer>();
    private final Map<Integer, Double> heights = new HashMap<Integer, Double>();
    final boolean selected;
    private boolean started = false;
    private final boolean finished = false;
    private PrintStream out;
    private final PageMargins pageMargins = new PageMargins();
    private final PageSetup pageSetup = new PageSetup();
    private String displayName;
    private final MergeCells mergeCells = new MergeCells();
    private int lastColumn;
    private final List<TwoCellAnchor> drawing = new ArrayList<TwoCellAnchor>();
    private Integer drawingFileId;
    private int drawingRelIdLast = 0;
    private Map<Image, Integer> imagesrels = new HashMap<Image, Integer>();
    private static final double K_IMAGEX = 0.1285;
    private static final double K_IMAGEY = 0.74;
    private static final long K_COLOFF = 65500L;
    private static final long K_ROWOFF = 11500L;

    public PageMargins pageMargins() {
        return this.pageMargins;
    }

    public PageSetup pageSetup() {
        return this.pageSetup;
    }

    public void setPageOrientation(PageSetup.Orientation orientation) {
        this.pageSetup.setOrientation(orientation);
    }

    public void setPageSize(PageSetup.PaperSize paperSize) {
        this.pageSetup.setPaperSize(paperSize);
    }

    public void setScaleByWidth() {
        this.pageSetup.setFitToHeight(0);
        this.pageSetup.setFitToWidth(1);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public double getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(double defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public Sheet cellFormula(int col, String formulaValue, NumFmt numFmt) {
        this.init();
        this.setLastColumn(col);
        this.style.numFmt = numFmt;
        if (formulaValue == null) {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"e\"><f></f></c>", pos, styleIndex);
            this.out.println();
        } else {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"e\"><f>%s</f></c>", pos, styleIndex, formulaValue);
            this.out.println();
        }
        return this;
    }

    public Sheet cellFormula(int col, String formulaValue) {
        this.init();
        this.setLastColumn(col);
        this.style.clearNumFmt();
        if (formulaValue == null) {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"e\"><f></f></c>", pos, styleIndex);
            this.out.println();
        } else {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"e\"><f>%s</f></c>", pos, styleIndex, formulaValue);
            this.out.println();
        }
        return this;
    }

    public Sheet cellInlineStr(int col, String strValue) {
        this.init();
        this.setLastColumn(col);
        this.style.clearNumFmt();
        if (strValue == null) {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"inlineStr\"></c>", pos, styleIndex);
            this.out.println();
        } else {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"inlineStr\"><is><t>" + strValue + "</t></is></c>", pos, styleIndex);
            this.out.println();
        }
        return this;
    }

    public Sheet cellStr(int col, String strValue) {
        this.init();
        this.setLastColumn(col);
        this.style.clearNumFmt();
        if (strValue == null) {
            int styleIndex = this.style.index();
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"s\"></c>", pos, styleIndex);
            this.out.println();
        } else {
            int styleIndex = this.style.index();
            int strIndex = this.strs.index(strValue);
            String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
            this.out.printf("<c r=\"%s\" s=\"%d\" t=\"s\"><v>%d</v></c>", pos, styleIndex, strIndex);
            this.out.println();
        }
        return this;
    }

    private void setLastColumn(int col) {
        if (col <= 0) {
            throw new IllegalArgumentException("must be col > 0, but col = " + col);
        }
        if (col <= this.lastColumn) {
            throw new IllegalArgumentException("must be col > " + this.lastColumn + ", but col = " + col);
        }
        this.lastColumn = col;
    }

    public Sheet cellInt(int col, int intValue) {
        this.init();
        this.setLastColumn(col);
        this.style.clearNumFmt();
        int styleIndex = this.style.index();
        String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
        this.out.printf("<c r=\"%s\" s=\"%d\"><v>%d</v></c>", pos, styleIndex, intValue);
        this.out.println();
        return this;
    }

    public Sheet cellDouble(int col, double doubleValue, NumFmt numFmt) {
        this.init();
        this.setLastColumn(col);
        this.style.numFmt = numFmt;
        int styleIndex = this.style.index();
        String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
        this.out.printf("<c r=\"%s\" s=\"%d\"><v>" + doubleValue + "</v></c>", pos, styleIndex);
        this.out.println();
        return this;
    }

    public Sheet cellDouble(int col, double doubleValue) {
        this.init();
        this.setLastColumn(col);
        this.style.clearNumFmt();
        int styleIndex = this.style.index();
        String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
        this.out.printf("<c r=\"%s\" s=\"%d\"><v>" + doubleValue + "</v></c>", pos, styleIndex);
        this.out.println();
        return this;
    }

    private Sheet cellDate(int col, Date date, NumFmt numFmt) {
        this.init();
        this.setLastColumn(col);
        this.style.numFmt = numFmt;
        int styleIndex = this.style.index();
        String pos = UtilOffice.toTablePosition(this.curRow, col - 1);
        this.out.printf("<c r=\"%s\" s=\"%d\"><v>%s</v></c>", pos, styleIndex, UtilOffice.toExcelDateTime(date));
        this.out.println();
        return this;
    }

    public Sheet cellYMD(int col, Date date) {
        return this.cellDate(col, date, NumFmt.YMD);
    }

    public Sheet cellYMD_HMS(int col, Date date) {
        return this.cellDate(col, date, NumFmt.YMD_HMS);
    }

    public Sheet cellDMY(int col, Date date) {
        return this.cellDate(col, date, NumFmt.DMY);
    }

    public void skipRows(int rowCount) {
        if (rowCount <= 0) {
            throw new IllegalArgumentException("rowCount must be > 0");
        }
        this.init();
        this.innerFinishRow();
        this.curRow += rowCount;
    }

    public void innerFinishRow() {
        if (!this.inRow) {
            return;
        }
        this.out.println("</row>");
        this.inRow = false;
    }

    public void skipRow() {
        this.init();
        this.skipRows(1);
    }

    public Row row() {
        return new Row();
    }

    public void cleanWidths() {
        this.checkNotStarted();
        this.widths.clear();
    }

    public void cleanHiddens() {
        this.checkNotStarted();
        this.colhiddens.clear();
    }

    private void checkNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Cannot change widths when data filling has begun");
        }
    }

    public void setWidth(int col, double width) {
        if (col <= 0) {
            throw new IllegalArgumentException("must be: col > 0, but col = " + col);
        }
        this.checkNotStarted();
        this.widths.put(col, width);
    }

    public void setHidden(int col) {
        if (col <= 0) {
            throw new IllegalArgumentException("must be: col > 0, but col = " + col);
        }
        this.checkNotStarted();
        this.colhiddens.add(col);
    }

    public Style style() {
        return this.style;
    }

    Sheet(Xlsx owner, Styles styles, int sheetNo, String workDir, SharedStrings strs, boolean selected) {
        this.parent = owner;
        this.name = "sheet" + sheetNo;
        this.displayName = "\u041b\u0438\u0441\u0442" + sheetNo;
        this.workDir = workDir;
        this.strs = strs;
        this.selected = selected;
        this.style = new Style(styles);
    }

    public String name() {
        return this.name;
    }

    private final void init() {
        if (this.started) {
            return;
        }
        try {
            this.initEx();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void initEx() throws Exception {
        if (this.started) {
            throw new IllegalArgumentException("Cannot start already started sheet");
        }
        File dir = new File(this.workDir + "/xl/worksheets");
        dir.mkdirs();
        this.out = new PrintStream((OutputStream)new FileOutputStream(dir.getPath() + "/" + this.name + ".xml"), true, "UTF-8");
        this.printHeader();
        this.started = true;
    }

    private void printHeader() {
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.out.println("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        this.printSheetPr();
        this.printSelected();
        this.out.println("<sheetFormatPr defaultRowHeight=\"" + this.defaultRowHeight + "\" />");
        this.printWidths();
        this.out.println("<sheetData>");
    }

    private void printSheetPr() {
        this.out.println("<sheetPr>");
        if (!this.pageSetup.printHeader(this.out)) {
            this.out.println("<outlinePr summaryBelow=\"" + (this.summaryBelow ? 1 : 0) + "\" summaryRight=\"" + (this.summaryRight ? 1 : 0) + "\" />");
        }
        this.out.println("</sheetPr>");
    }

    private void printSelected() {
        if (this.selected) {
            this.out.println("<sheetViews>");
            this.out.println("<sheetView tabSelected=\"1\" workbookViewId=\"0\">");
            this.out.println("<selection activeCell=\"A1\" sqref=\"A1\" />");
            this.out.println("</sheetView>");
            this.out.println("</sheetViews>");
        } else {
            this.out.println("<sheetViews>");
            this.out.println("<sheetView workbookViewId=\"0\" />");
            this.out.println("</sheetViews>");
        }
    }

    private void printWidths() {
        if (this.widths.size() == 0 && this.colhiddens.size() == 0) {
            return;
        }
        TreeSet<Integer> keys = new TreeSet<Integer>();
        keys.addAll(this.widths.keySet());
        keys.addAll(this.colhiddens);
        this.out.println("<cols>");
        for (Integer key : keys) {
            this.out.printf("<col min=\"%d\" max=\"%d\" ", key, key);
            if (this.widths.get(key) != null) {
                this.out.printf("width=\"%s\" ", this.widths.get(key).toString());
            }
            if (this.colhiddens.contains(key)) {
                this.out.printf("hidden=\"1\" ", new Object[0]);
            }
            this.out.printf("customWidth=\"1\" />", new Object[0]);
        }
        this.out.println("</cols>");
    }

    void finish() {
        this.out.println("</sheetData>");
        this.mergeCells.print(this.out);
        this.pageMargins.print(this.out);
        this.pageSetup.print(this.out);
        this.printDrawings();
        this.out.println("</worksheet>");
        this.out.close();
        this.out = null;
    }

    public void addMergeInRow(int colFrom, int colTo) {
        this.mergeCells.addMerge(this.curRow, colFrom, this.curRow, colTo);
    }

    public void addMerge(int rowFrom, int colFrom, int rowTo, int colTo) {
        this.mergeCells.addMerge(rowFrom, colFrom, rowTo, colTo);
    }

    public void addMergeRel(int rowFrom, int colFrom, int rowTo, int colTo) {
        this.mergeCells.addMerge(this.curRow + rowFrom, colFrom, this.curRow + rowTo, colTo);
    }

    public void addMergeCount(int colFrom, int colTo, int rowsCount) {
        if (rowsCount > 0) {
            this.mergeCells.addMerge(this.curRow, colFrom, this.curRow + rowsCount, colTo);
        } else {
            this.mergeCells.addMerge(this.curRow + rowsCount, colFrom, this.curRow, colTo);
        }
    }

    public boolean isSummaryBelow() {
        return this.summaryBelow;
    }

    public void setSummaryBelow(boolean summaryBelow) {
        this.summaryBelow = summaryBelow;
    }

    public boolean isSummaryRight() {
        return this.summaryRight;
    }

    public void setSummaryRight(boolean summaryRight) {
        this.summaryRight = summaryRight;
    }

    public Chart addChart(ChartType type, SheetCoord coordFrom, SheetCoord coordTo) {
        Chart chart = this.parent.newChart(type, ++this.drawingRelIdLast);
        this.addChart(chart, coordFrom, coordTo);
        return chart;
    }

    public Chart addChart(ChartType type, String cellFrom, String cellTo) {
        Chart chart = this.parent.newChart(type, ++this.drawingRelIdLast);
        this.addChart(chart, new SheetCoord(cellFrom), new SheetCoord(cellTo));
        return chart;
    }

    @Deprecated
    public Chart addChart(ChartType type, int colFrom, int rowFrom, int colTo, int rowTo) {
        Chart chart = this.parent.newChart(type, ++this.drawingRelIdLast);
        this.addChart(chart, new SheetCoord(colFrom, rowFrom), new SheetCoord(colTo, rowTo));
        return chart;
    }

    @Deprecated
    public Chart addChart(ChartType type, String colFrom, int rowFrom, String colTo, int rowTo) {
        return this.addChart(type, new SheetCoord(colFrom, rowFrom), new SheetCoord(colTo, rowTo));
    }

    public void addChart(Chart chart, SheetCoord coordFrom, SheetCoord coordTo) {
        this.setDrawingId();
        TwoCellAnchorChart anchor = new TwoCellAnchorChart(chart, coordFrom, coordTo);
        this.drawing.add(anchor);
    }

    public void addChart(Chart chart, String cellFrom, String cellTo) {
        this.setDrawingId();
        TwoCellAnchorChart anchor = new TwoCellAnchorChart(chart, new SheetCoord(cellFrom), new SheetCoord(cellTo));
        this.drawing.add(anchor);
    }

    @Deprecated
    public void addChart(Chart chart, int colFrom, int rowFrom, int colTo, int rowTo) {
        this.setDrawingId();
        TwoCellAnchorChart anchor = new TwoCellAnchorChart(chart, new SheetCoord(colFrom, rowFrom), new SheetCoord(colTo, rowTo));
        this.drawing.add(anchor);
    }

    @Deprecated
    public void addChart(Chart chart, String colFrom, int rowFrom, String colTo, int rowTo) {
        this.addChart(chart, new SheetCoord(colFrom, rowFrom), new SheetCoord(colTo, rowTo));
    }

    public Image addImage(byte[] img, ImageType type, SheetCoord coordFrom, SheetCoord coordTo) {
        InputStream is = this.getISFromBytes(img, type);
        return this.addImage(is, type, coordFrom, coordTo);
    }

    public Image addImage(byte[] img, ImageType type, SheetCoord coordFrom, int percentOfSize) {
        InputStream is = this.getISFromBytes(img, type);
        return this.addImage(is, type, coordFrom, percentOfSize);
    }

    public Image addImage(File file, SheetCoord coordFrom, SheetCoord coordTo) {
        InputStream is = this.getISFromFile(file);
        ImageType type = this.getImageTypeFromFile(file);
        return this.addImage(is, type, coordFrom, coordTo);
    }

    public Image addImage(File file, SheetCoord coordFrom, int percentOfSize) {
        InputStream is = this.getISFromFile(file);
        ImageType type = this.getImageTypeFromFile(file);
        return this.addImage(is, type, coordFrom, percentOfSize);
    }

    public Image addImage(InputStream is, ImageType type, SheetCoord coordFrom, SheetCoord coordTo) {
        Image image = this.addImageFile(is, type);
        this.addImage(image, coordFrom, coordTo);
        return image;
    }

    public Image addImage(InputStream is, ImageType type, SheetCoord coordFrom, int percentOfSize) {
        Image image = this.addImageFile(is, type);
        this.addImage(image, coordFrom, percentOfSize);
        return image;
    }

    public void addImage(Image image, SheetCoord coordFrom, SheetCoord coordTo) {
        if (image == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
        }
        if (image.getFilename() == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
        }
        this.setDrawingId();
        Integer imagerel = this.imagesrels.get(image);
        if (imagerel == null) {
            this.imagesrels.put(image, ++this.drawingRelIdLast);
        }
        TwoCellAnchorImage anchor = new TwoCellAnchorImage(this.imagesrels.get(image), image, coordFrom, coordTo);
        this.drawing.add(anchor);
        this.parent.imageexts.add(image.getImageType().getExt());
    }

    public void addImage(Image image, SheetCoord coordFrom, int percentOfSize) {
        double imageheight;
        double imagewidth;
        SheetCoord coordTo = new SheetCoord();
        coordTo.col = coordFrom.col;
        coordTo.row = coordFrom.row;
        double imagewidthexp = (double)image.width * 0.1285 * (double)percentOfSize / 100.0;
        double imageheightexp = (double)image.height * 0.74 * (double)percentOfSize / 100.0;
        for (imagewidth = this.getColWidth(coordFrom.col) - (double)((long)coordFrom.coloff / 65500L); imagewidth < imagewidthexp; imagewidth += this.getColWidth(coordFrom.col)) {
            ++coordTo.col;
        }
        coordTo.coloff = (int)((imagewidthexp - imagewidth) * 65500.0);
        for (imageheight = this.getRowHeight(coordFrom.row) - (double)((long)coordFrom.rowoff / 11500L); imageheight < imageheightexp; imageheight += this.getRowHeight(coordFrom.row)) {
            ++coordTo.row;
        }
        coordTo.rowoff = (int)((imageheightexp - imageheight) * 11500.0);
        this.addImage(image, coordFrom, coordTo);
    }

    private double getColWidth(int col) {
        double width = 8.43;
        Double mapwidth = this.widths.get(col);
        if (mapwidth != null && mapwidth > 0.0) {
            width = mapwidth;
        }
        return width;
    }

    private double getRowHeight(int row) {
        double height = 15.0;
        Double mapheight = this.heights.get(row);
        if (mapheight != null && mapheight > 0.0) {
            height = mapheight;
        }
        return height;
    }

    private Image addImageFile(InputStream is, ImageType type) {
        if (is == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u043e\u0442\u043e\u043a \u0441 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c");
        }
        if (type == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
        }
        int fileid = this.parent.newImageFileId();
        String filename = "image" + fileid + "." + type.getExt();
        Image image = new Image(filename, type);
        try {
            String dir = this.workDir + "/xl/media";
            new File(dir).mkdirs();
            File os = new File(dir + "/" + filename);
            Files.copy(is, os.toPath(), new CopyOption[0]);
            is.close();
            BufferedImage img = ImageIO.read(os);
            image.height = img.getHeight();
            image.width = img.getWidth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    private InputStream getISFromBytes(byte[] img, ImageType type) {
        if (img == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
        }
        if (img.length == 0) {
            throw new IllegalArgumentException("\u0417\u0430\u0434\u0430\u043d\u043e \u043f\u0443\u0441\u0442\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
        }
        if (type == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(img);
        return is;
    }

    private InputStream getISFromFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0444\u0430\u0439\u043b \u0441 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u0441 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u0441 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", ex);
        }
        return is;
    }

    private ImageType getImageTypeFromFile(File file) {
        ImageType type = ImageType.getByExt(file.getName().substring(file.getName().lastIndexOf(".") + 1));
        if (type == null) {
            throw new IllegalArgumentException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
        }
        return type;
    }

    private void setDrawingId() {
        if (this.drawingFileId != null) {
            return;
        }
        this.drawingFileId = this.parent.getDrawingIdNext();
    }

    Integer getDrawingId() {
        return this.drawingFileId;
    }

    List<TwoCellAnchor> getDrawing() {
        return this.drawing;
    }

    Map<Image, Integer> getImagesRels() {
        return this.imagesrels;
    }

    private void printDrawings() {
        if (this.drawingFileId == null) {
            return;
        }
        this.out.println("<drawing r:id=\"rId" + this.getDrawingId() + "\"/>");
        try {
            String dir = this.workDir + "/xl/worksheets/_rels";
            new File(dir).mkdirs();
            PrintStream os = new PrintStream(dir + "/" + this.name + ".xml.rels", "UTF-8");
            os.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            os.print("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId");
            os.print(this.getDrawingId());
            os.print("\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing\" Target=\"../drawings/drawing");
            os.print(this.getDrawingId());
            os.println(".xml\"/>");
            os.print("</Relationships>");
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class Row {
        private Double height = null;
        private boolean collapsed = false;
        private boolean hidden = false;
        private int outlineLevel = 0;

        private Row() {
        }

        public Row height(double height) {
            this.height = height;
            return this;
        }

        public Row collapsed() {
            this.collapsed = true;
            return this;
        }

        public Row hidden() {
            this.hidden = true;
            return this;
        }

        public Row hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Row collapsed(boolean collapsed) {
            this.collapsed = collapsed;
            return this;
        }

        public Row outline() {
            this.outlineLevel = 1;
            return this;
        }

        public Row outline(boolean hidden) {
            this.outlineLevel = 1;
            this.hidden = hidden;
            return this;
        }

        public Row hiddenOutline() {
            this.outlineLevel = 1;
            this.hidden = true;
            return this;
        }

        public Row outlineLevel(int outlineLevel) {
            if (outlineLevel < 1) {
                throw new IllegalArgumentException("outlineLevel must be > 0");
            }
            this.outlineLevel = outlineLevel;
            return this;
        }

        public Row outlineLevel(int outlineLevel, boolean hidden) {
            if (outlineLevel < 1) {
                throw new IllegalArgumentException("outlineLevel must be > 0");
            }
            this.hidden = hidden;
            this.outlineLevel = outlineLevel;
            return this;
        }

        public Row start() {
            Sheet.this.init();
            Sheet.this.innerFinishRow();
            Sheet.this.lastColumn = 0;
            StringBuilder after = new StringBuilder();
            Sheet.this.out.printf("<row r=\"%d\"", ++Sheet.this.curRow);
            if (this.height != null) {
                after.append(" customHeight=\"1\"");
                Sheet.this.out.printf(" ht=\"%s\"", this.height.toString());
                Sheet.this.heights.put(Sheet.this.curRow, this.height);
            }
            if (this.hidden) {
                Sheet.this.out.print(" hidden=\"1\"");
            }
            if (this.outlineLevel > 0) {
                Sheet.this.out.printf(" outlineLevel=\"%d\"", this.outlineLevel);
            }
            if (this.collapsed) {
                Sheet.this.out.print(" collapsed=\"1\"");
            }
            Sheet.this.out.print(after.toString());
            Sheet.this.out.println('>');
            Sheet.this.inRow = true;
            return this;
        }

        public void finish() {
            Sheet.this.innerFinishRow();
        }
    }
}

