/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.xlsx.gen.Borders;
import kz.greetgo.msoffice.xlsx.gen.Fill;
import kz.greetgo.msoffice.xlsx.gen.Font;
import kz.greetgo.msoffice.xlsx.gen.NumFmt;
import kz.greetgo.msoffice.xlsx.gen.PatternFill;
import kz.greetgo.msoffice.xlsx.gen.PatternFillType;
import kz.greetgo.msoffice.xlsx.gen.Style;

class Styles {
    private final List<Fill> fills = new ArrayList<Fill>();
    private final List<Borders> bordersList = new ArrayList<Borders>();
    private final List<Font> fonts = new ArrayList<Font>();
    private final List<Style> styles = new ArrayList<Style>();

    int fillIndex(Fill fill) {
        if (fill == null) {
            fill = new PatternFill(PatternFillType.none);
        }
        int index = 0;
        for (Fill f : this.fills) {
            if (f.equals(fill)) {
                return index;
            }
            ++index;
        }
        this.fills.add(fill.copy());
        return index;
    }

    int bordersIndex(Borders borders) {
        if (borders == null) {
            borders = new Borders();
        }
        int index = 0;
        for (Borders b : this.bordersList) {
            if (b.equals(borders)) {
                return index;
            }
            ++index;
        }
        this.bordersList.add(new Borders(borders));
        return index;
    }

    int fontIndex(Font font) {
        if (font == null) {
            font = new Font();
        }
        int index = 0;
        for (Font f : this.fonts) {
            if (f.equals(font)) {
                return index;
            }
            ++index;
        }
        this.fonts.add(new Font(font));
        return index;
    }

    int styleIndex(Style style) {
        int index = 0;
        for (Style s : this.styles) {
            if (s.equals(style)) {
                return index;
            }
            ++index;
        }
        this.styles.add(style.copy());
        return index;
    }

    public Styles() {
        this.fills.add(new PatternFill(PatternFillType.none));
        this.bordersList.add(new Borders());
    }

    void print(PrintStream out) {
        this.indexAll();
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("<styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
        NumFmt.printAll(out);
        this.printFonts(out);
        this.printFills(out);
        this.printBorders(out);
        this.printCellStyleXfs(out);
        this.printCellXfs(out);
        out.println("</styleSheet>");
    }

    private void printCellStyleXfs(PrintStream out) {
        out.println("<cellStyleXfs count=\"1\">");
        out.println("<xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\" />");
        out.println("</cellStyleXfs>");
    }

    private void indexAll() {
        for (Style style : this.styles) {
            this.fontIndex(style.font);
            this.fillIndex(style.fill);
            this.bordersIndex(style.borders);
        }
    }

    private void printFonts(PrintStream out) {
        out.println("<fonts count=\"" + this.fonts.size() + "\">");
        for (Font font : this.fonts) {
            font.print(out);
        }
        out.println("</fonts>");
    }

    private void printFills(PrintStream out) {
        out.println("<fills count=\"" + this.fills.size() + "\">");
        for (Fill fill : this.fills) {
            fill.print(out);
        }
        out.println("</fills>");
    }

    private void printBorders(PrintStream out) {
        out.println("<borders count=\"" + this.bordersList.size() + "\">");
        for (Borders borders : this.bordersList) {
            borders.print(out);
        }
        out.println("</borders>");
    }

    private void printCellXfs(PrintStream out) {
        out.println("<cellXfs count=\"" + this.bordersList.size() + "\">");
        for (Style style : this.styles) {
            style.print(out);
        }
        out.println("</cellXfs>");
    }
}

