/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.parse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class SharedStrings {
    private static final int SPACE_FOR_HEADER = 200;
    private final File file;
    private PrintStream printStream;
    private int index = 0;

    public SharedStrings(String workDir) throws Exception {
        this.file = new File(workDir + "/xl/sharedStrings.xml");
        this.prepareFile();
    }

    private final void prepareFile() throws Exception {
        this.file.getParentFile().mkdirs();
        this.printStream = new PrintStream((OutputStream)new FileOutputStream(this.file), false, "UTF-8");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            sb.append(' ');
        }
        sb.append("\r\n");
        this.printStream.print(sb.toString());
    }

    public int index(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append("<si><t>");
        if (str == null) {
            str = "";
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        sb.append(str);
        sb.append("</t></si>\r\n");
        this.printStream.print(sb.toString());
        return this.index++;
    }

    public void close() throws Exception {
        this.printStream.print("</sst>");
        this.printStream.flush();
        this.printStream.close();
        this.printStream = null;
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        FileChannel fc = raf.getChannel();
        fc.position(0L);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n");
        sb.append("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"" + this.index + "\" uniqueCount=\"" + this.index + "\">");
        ByteBuffer buf = ByteBuffer.wrap(sb.toString().getBytes("UTF-8"));
        while (buf.hasRemaining()) {
            fc.write(buf);
        }
        fc.close();
        raf.close();
    }
}

