/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.parse;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import kz.greetgo.msoffice.xlsx.parse.XmlIn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SharedStringsHandler
extends DefaultHandler {
    private final Connection connection;
    private long nom = 0L;
    private final XmlIn in = new XmlIn();
    PreparedStatement strInsertPS = null;
    private int currentBachSize = 0;
    private static final int MAX_BATCH_SIZE = 2000;
    private StringBuilder textBuilder = null;

    public SharedStringsHandler(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.strInsertPS = this.connection.prepareStatement("insert into strs (nom, value) values (?, ?)");
            this.currentBachSize = 0;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.currentBachSize > 0) {
                this.commit();
            }
            this.strInsertPS.close();
            this.strInsertPS = null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.textBuilder = null;
        this.in.stepIn(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("sst/si/t".equals(this.in.current())) {
            this.appendString(this.text());
        }
        this.in.stepOut();
    }

    private String text() {
        if (this.textBuilder == null) {
            return "";
        }
        return this.textBuilder.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textBuilder == null) {
            this.textBuilder = new StringBuilder();
        }
        this.textBuilder.append(ch, start, length);
    }

    private void appendString(String string) {
        try {
            this.appendStringEx(string);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendStringEx(String string) throws SQLException {
        this.strInsertPS.setLong(1, this.nom++);
        this.strInsertPS.setString(2, string);
        this.strInsertPS.addBatch();
        ++this.currentBachSize;
        if (this.currentBachSize >= 2000) {
            this.commit();
        }
    }

    private void commit() throws SQLException {
        this.strInsertPS.executeBatch();
        this.connection.commit();
        this.currentBachSize = 0;
    }
}

