/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.parse;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kz.greetgo.msoffice.UtilOffice;
import kz.greetgo.msoffice.xlsx.parse.Cell;
import kz.greetgo.msoffice.xlsx.parse.CellHandler;
import kz.greetgo.msoffice.xlsx.parse.RowHandler;
import kz.greetgo.msoffice.xlsx.parse.Sheet;
import kz.greetgo.msoffice.xlsx.parse.XmlIn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SheetHandlerMemory
extends DefaultHandler
implements Sheet {
    private final int sheetNo;
    private final String name;
    private boolean active;
    private Map<Long, Map<Integer, MyCell>> rows = new TreeMap<Long, Map<Integer, MyCell>>();
    private Map<Integer, Map<Long, Integer>> rowLength = new TreeMap<Integer, Map<Long, Integer>>();
    private final Map<Long, String> values;
    private final XmlIn in = new XmlIn();
    final CellInfo cell = new CellInfo();
    private StringBuilder textBuilder = null;

    public SheetHandlerMemory(String sheetPathName, int sheetNo, Map<Long, String> values) {
        this.sheetNo = sheetNo;
        this.values = values;
        int startLen = "xl/worksheets/".length();
        int endLen = ".xml".length();
        this.name = sheetPathName.substring(startLen, sheetPathName.length() - endLen);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.textBuilder = null;
        this.in.stepIn(qName);
        if ("worksheet/sheetData/row/c".equals(this.in.current())) {
            this.cell.r = attributes.getValue("r");
            this.cell.t = attributes.getValue("t");
            this.cell.s = attributes.getValue("s");
        }
        if ("worksheet/sheetViews/sheetView".equals(this.in.current()) && "1".equals(attributes.getValue("tabSelected"))) {
            this.active = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("worksheet/sheetData/row/c/v".equals(this.in.current())) {
            this.cell.v = this.text();
            this.appendCell(this.cell);
        }
        this.in.stepOut();
    }

    private String text() {
        if (this.textBuilder == null) {
            return "";
        }
        return this.textBuilder.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textBuilder == null) {
            this.textBuilder = new StringBuilder();
        }
        this.textBuilder.append(ch, start, length);
    }

    private void appendCell(CellInfo cell) {
        try {
            this.putIntoMap(cell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void putIntoMap(CellInfo cell) throws CloneNotSupportedException {
        Map<Long, Integer> rows;
        Map<Integer, MyCell> row;
        cell.calcRowCol();
        if (!this.rows.containsKey(cell.row - 1L)) {
            this.rows.put(cell.row - 1L, new TreeMap());
        }
        if (!(row = this.rows.get(cell.row - 1L)).containsKey(cell.col)) {
            row.put(cell.col, new MyCell(this.sheetNo, (int)(cell.row - 1L), cell.col, cell.t, cell.s, cell.v));
        }
        if (!this.rowLength.containsKey(this.sheetNo)) {
            this.rowLength.put(this.sheetNo, new TreeMap());
        }
        if (!(rows = this.rowLength.get(this.sheetNo)).containsKey(cell.row - 1L)) {
            rows.put(cell.row - 1L, cell.col);
        } else {
            rows.put(cell.row - 1L, Math.max(rows.get(cell.row - 1L), cell.col));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void scanCells(CellHandler handler) {
        try {
            this.scanCellsEx(handler);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void scanCellsEx(CellHandler handler) throws Exception {
        for (Map<Integer, MyCell> row : this.rows.values()) {
            for (MyCell cell : row.values()) {
                handler.handle(cell);
            }
        }
    }

    @Override
    public List<Cell> loadRow(int row) {
        try {
            return this.loadRowEx(row);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private List<Cell> loadRowEx(int row) throws SQLException {
        ArrayList<Cell> ret = new ArrayList<Cell>();
        if (this.rows.get(row) != null) {
            Integer maxColumn;
            Map<Integer, MyCell> r = this.rows.get(row);
            Map<Long, Integer> m = this.rowLength.get(this.sheetNo);
            Integer n = maxColumn = m != null ? m.get(row) : null;
            if (maxColumn != null) {
                for (int i = 0; i <= maxColumn; ++i) {
                    MyCell myCell = r.get(i);
                    if (myCell != null && myCell.isStr()) {
                        myCell.value = this.values.get(Long.parseLong(myCell.v));
                    }
                    ret.add(myCell);
                }
            }
        }
        return ret;
    }

    @Override
    public void scanRows(int colCountInRow, RowHandler handler) {
        try {
            this.scanRowsEx(colCountInRow, handler);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void scanRowsEx(int colCountInRow, RowHandler handler) throws Exception {
        for (Map.Entry<Long, Map<Integer, MyCell>> row : this.rows.entrySet()) {
            ArrayList<Cell> r = new ArrayList<Cell>();
            for (int i = 0; i < colCountInRow; ++i) {
                MyCell myCell = row.getValue().get(i);
                if (myCell != null && myCell.isStr()) {
                    myCell.value = this.values.get(Long.parseLong(myCell.v));
                }
                r.add(myCell);
            }
            handler.handle(r, row.getKey().intValue());
        }
    }

    private class MyCell
    extends Cell {
        public int sheet_id;
        public String value;

        MyCell() {
        }

        MyCell(int sheet_id, int row, int col, String t, String s, String v) {
            this.sheet_id = sheet_id;
            this.row = row;
            this.col = col;
            this.t = t;
            this.s = s;
            this.v = v;
        }

        MyCell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        @Override
        public String asStr() {
            if (this.isStr()) {
                return this.value;
            }
            return this.v;
        }

        @Override
        public Date asDate() {
            if (this.isStr()) {
                return null;
            }
            return UtilOffice.excelToDate(this.asStr());
        }

        @Override
        public Integer asInt() {
            BigDecimal bd = this.asBigDecimal();
            return bd == null ? null : Integer.valueOf(bd.intValue());
        }

        @Override
        public Long asLong() {
            BigDecimal bd = this.asBigDecimal();
            return bd == null ? null : Long.valueOf(bd.longValue());
        }

        @Override
        public BigDecimal asBigDecimal() {
            String s = this.value;
            if (this.isStr()) {
                return null;
            }
            if (s == null) {
                return null;
            }
            return new BigDecimal(s);
        }
    }

    private static class CellInfo
    implements Cloneable {
        String r;
        String t;
        String s;
        String v;
        long row;
        int col;

        private CellInfo() {
        }

        public void calcRowCol() {
            char c;
            int index;
            for (index = 0; index < this.r.length() && ('0' > (c = this.r.charAt(index)) || c > '9'); ++index) {
            }
            this.row = Long.parseLong(this.r.substring(index));
            this.col = UtilOffice.parseLettersNumber(this.r.substring(0, index));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.col;
            result = 31 * result + (int)(this.row ^ this.row >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellInfo other = (CellInfo)obj;
            if (this.col != other.col) {
                return false;
            }
            return this.row == other.row;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

