/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.parse;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kz.greetgo.msoffice.UtilOffice;
import kz.greetgo.msoffice.xlsx.parse.SharedStringsHandler;
import kz.greetgo.msoffice.xlsx.parse.Sheet;
import kz.greetgo.msoffice.xlsx.parse.SheetHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxParser {
    private String tmpDirBase = System.getProperty("java.io.tmpdir", ".");
    private SAXParser saxParser;
    public boolean removeWorkDirOnClose = true;
    private final List<Sheet> sheets = new ArrayList<Sheet>();
    private String workDir = null;
    private Connection connection;

    private SAXParser saxParser() throws Exception {
        if (this.saxParser == null) {
            SAXParserFactory fact = SAXParserFactory.newInstance();
            this.saxParser = fact.newSAXParser();
        }
        return this.saxParser;
    }

    public void setTmpDirBase(String tmpDirBase) {
        if (this.workDir != null) {
            throw new IllegalStateException("Cannot change this property on active parser. Call method 'close' to deactivate this parser");
        }
        this.tmpDirBase = tmpDirBase;
    }

    private String workDir() {
        if (this.workDir == null) {
            String newName = "xlsxParser-" + System.currentTimeMillis() + "-" + new Random().nextLong();
            this.workDir = this.tmpDirBase + "/" + newName;
            new File(this.workDir).mkdirs();
        }
        return this.workDir;
    }

    public void closeEx() throws Exception {
        if (this.workDir == null) {
            return;
        }
        if (this.connection != null) {
            block5: {
                this.connection.rollback();
                this.connection.close();
                try {
                    this.connection = DriverManager.getConnection("jdbc:derby:" + this.workDir() + "/db;shutdown=true");
                }
                catch (SQLException sqle) {
                    if ("08006".equals(sqle.getSQLState())) break block5;
                    throw sqle;
                }
            }
            this.connection.close();
        }
        if (this.removeWorkDirOnClose) {
            UtilOffice.removeDir(this.workDir);
        }
        this.workDir = null;
    }

    public void close() {
        try {
            this.closeEx();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void load(InputStream in) {
        try {
            this.loadEx(in);
        }
        catch (Exception e) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEx(InputStream in) throws Exception {
        ZipEntry entry;
        this.prepareDB();
        ZipInputStream zin = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
        int sheetNo = 1;
        while ((entry = zin.getNextEntry()) != null) {
            if ("xl/sharedStrings.xml".equals(entry.getName())) {
                this.saxParser().parse(UtilOffice.copy(zin), (DefaultHandler)new SharedStringsHandler(this.connection));
                zin.closeEntry();
                continue;
            }
            if (entry.getName().startsWith("xl/worksheets/") && entry.getName().endsWith(".xml")) {
                SheetHandler handler = new SheetHandler(this.connection, entry.getName(), sheetNo++);
                try {
                    this.saxParser().parse(UtilOffice.copy(zin), (DefaultHandler)handler);
                }
                finally {
                    handler.finishInsertion();
                }
                zin.closeEntry();
                this.sheets.add(handler);
                continue;
            }
            zin.closeEntry();
        }
        zin.close();
    }

    private void prepareDB() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        this.connection = DriverManager.getConnection("jdbc:derby:" + this.workDir() + "/db;create=true");
        PreparedStatement ps = this.connection.prepareStatement("create table strs (nom bigint not null primary key, value clob)");
        ps.execute();
        ps.close();
        ps = this.connection.prepareStatement(UtilOffice.streamToStr(this.getClass().getResourceAsStream("create_table_SHEETS.sql")));
        ps.execute();
        ps.close();
        ps = this.connection.prepareStatement(UtilOffice.streamToStr(this.getClass().getResourceAsStream("create_table_CELLS.sql")));
        ps.execute();
        ps.close();
    }

    public List<Sheet> sheets() {
        return this.sheets;
    }

    public Sheet activeSheet() {
        for (Sheet sheet : this.sheets) {
            if (!sheet.isActive()) continue;
            return sheet;
        }
        if (this.sheets.size() > 0) {
            return this.sheets.get(0);
        }
        return null;
    }
}

