/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.parse;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kz.greetgo.msoffice.UtilOffice;
import kz.greetgo.msoffice.xlsx.parse.SharedStringsHandlerMemory;
import kz.greetgo.msoffice.xlsx.parse.Sheet;
import kz.greetgo.msoffice.xlsx.parse.SheetHandlerMemory;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxParserMemory {
    private SAXParser saxParser;
    public boolean removeWorkDirOnClose = true;
    private final Map<Long, String> values = new TreeMap<Long, String>();
    private final List<Sheet> sheets = new ArrayList<Sheet>();

    private SAXParser saxParser() throws Exception {
        if (this.saxParser == null) {
            SAXParserFactory fact = SAXParserFactory.newInstance();
            this.saxParser = fact.newSAXParser();
        }
        return this.saxParser;
    }

    public void load(InputStream in) {
        try {
            this.loadEx(in);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void loadEx(InputStream in) throws Exception {
        ZipEntry entry;
        ZipInputStream zin = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
        int sheetNo = 1;
        while ((entry = zin.getNextEntry()) != null) {
            if ("xl/sharedStrings.xml".equals(entry.getName())) {
                this.saxParser().parse(UtilOffice.copy(zin), (DefaultHandler)new SharedStringsHandlerMemory(this.values));
                zin.closeEntry();
                continue;
            }
            if (entry.getName().startsWith("xl/worksheets/") && entry.getName().endsWith(".xml")) {
                SheetHandlerMemory handler = new SheetHandlerMemory(entry.getName(), sheetNo++, this.values);
                this.saxParser().parse(UtilOffice.copy(zin), (DefaultHandler)handler);
                zin.closeEntry();
                this.sheets.add(handler);
                continue;
            }
            zin.closeEntry();
        }
        zin.close();
    }

    public List<Sheet> sheets() {
        return this.sheets;
    }

    public Sheet activeSheet() {
        for (Sheet sheet : this.sheets) {
            if (!sheet.isActive()) continue;
            return sheet;
        }
        if (this.sheets.size() > 0) {
            return this.sheets.get(0);
        }
        return null;
    }
}

