package kz.greetgo.msoffice.xlsx.gen;

/**
 * Тип узора заливки
 *
 * @author pompei
 */
public enum PatternFillType {
  /**
   * Нет заливки
   */
  none,

  /**
   * Заливка сплошным цветом (используется bgColor)
   */
  solid,

  /**
   * Заливка точками (очень много точек)
   */
  gray125,

  /**
   * Заливка точками (много точек)
   */
  darkGray,

  /**
   * Заливка точками (среднее покрытие точками)
   */
  mediumGray,

  /**
   * Заливка точками (мало точек)
   */
  lightGray,

  /**
   * Заливка точками (очень мало точек)
   */
  gray0625,

  /**
   * Заливка горизонтальными толстыми линиями
   */
  darkHorizontal,

  /**
   * Заливка горизонтальными тонкими линиями
   */
  lightHorizontal,

  /**
   * Заливка выртикальными толстыми линиями
   */
  darkVertical,

  /**
   * Заливка выртикальными тонкими линиями
   */
  lightVertical,

  /**
   * Заливка так \\\\\ (толстые линии)
   */
  darkDown,

  /**
   * Заливка так \\\\\ (тонкие линии)
   */
  lightDown,

  /**
   * Заливка так ///// (толстые линии)
   */
  darkUp,

  /**
   * Заливка так ///// (тонкие линии)
   */
  lightUp,

  /**
   * Заливка жирной диагональной сеткой
   */
  darkGrid,

  /**
   * Заливка бледной вертикально-горизонтальной сеткой
   */
  lightGrid,

  /**
   * Особый тёмный узор
   */
  darkTrellis,

  /**
   * Особый светлый узор
   */
  lightTrellis
}
