/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kz.greetgo.msoffice.docx.ContentElement;
import kz.greetgo.msoffice.docx.ContentType;
import kz.greetgo.msoffice.docx.CoreProperties;
import kz.greetgo.msoffice.docx.Document;
import kz.greetgo.msoffice.docx.DocumentFooter;
import kz.greetgo.msoffice.docx.DocumentHeader;
import kz.greetgo.msoffice.docx.ExtendedProperties;
import kz.greetgo.msoffice.docx.FilePart;
import kz.greetgo.msoffice.docx.FontTableContentElement;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.XmlWriter;

class Content
implements FilePart {
    private final MSHelper msHelper;
    private boolean defaultImagePngExists = false;
    private List<Default> defaults = new ArrayList<Default>();
    private List<ContOverride> overrides = new ArrayList<ContOverride>();
    private FontTableContentElement fontTableContentElement;

    void checkExistsDefaultImagePng() {
        if (this.defaultImagePngExists) {
            return;
        }
        this.defaults.add(new Default(ContentType.IMAGE_PNG, "png"));
        this.defaultImagePngExists = true;
    }

    private Content(MSHelper msHelper) {
        this.msHelper = msHelper;
    }

    static Content createDefaultContent(MSHelper msHelper) {
        Content ret = new Content(msHelper);
        ret.initDefault();
        return ret;
    }

    private void initDefault() {
        this.defaults.add(new Default(ContentType.APPLICATION_XML, "xml"));
        this.defaults.add(new Default(ContentType.RELATIONSHIPS, "rels"));
        this.overrides.add(new ContOverride(new CoreProperties("/docProps/core.xml")));
        this.overrides.add(new ContOverride(new ExtendedProperties("/docProps/app.xml")));
        this.overrides.add(new ContOverride(new Document("/word/document.xml", this.msHelper)));
    }

    FontTableContentElement getFontTableContentElement() {
        if (this.fontTableContentElement == null) {
            this.fontTableContentElement = FontTableContentElement.createDefault("/word/fontTable.xml");
            this.overrides.add(new ContOverride(this.fontTableContentElement));
        }
        return this.fontTableContentElement;
    }

    void addFontTableOverride() {
        this.overrides.add(new ContOverride(new CoreProperties("/docProps/core.xml")));
    }

    public CoreProperties getCoreProperties() {
        for (ContOverride o : this.overrides) {
            if (ContentType.CORE_PROPERTIES != o.getContentType()) continue;
            return (CoreProperties)o.getContentElement();
        }
        throw new IllegalStateException("No core properties");
    }

    public ExtendedProperties getExtendedProperties() {
        for (ContOverride o : this.overrides) {
            if (ContentType.EXTENDED_PROPERTIES != o.getContentType()) continue;
            return (ExtendedProperties)o.getContentElement();
        }
        throw new IllegalStateException("No extended properties");
    }

    public Document getDocument() {
        for (ContOverride o : this.overrides) {
            if (ContentType.DOCUMENT != o.getContentType()) continue;
            return (Document)o.getContentElement();
        }
        throw new IllegalStateException("No document");
    }

    @Override
    public void write(PrintStream out) {
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">");
        for (Default d : this.defaults) {
            d.write(out);
        }
        for (ContOverride o : this.overrides) {
            o.write(out);
        }
        out.print("</Types>");
    }

    DocumentHeader getOrCreateHeader() {
        for (ContOverride o : this.overrides) {
            if (ContentType.HEADER != o.getContentType()) continue;
            return (DocumentHeader)o.getContentElement();
        }
        DocumentHeader o = new DocumentHeader("/word/header1.xml", this.msHelper);
        this.overrides.add(new ContOverride(o));
        return o;
    }

    DocumentFooter getOrCreateFooter() {
        for (ContOverride o : this.overrides) {
            if (ContentType.FOOTER != o.getContentType()) continue;
            return (DocumentFooter)o.getContentElement();
        }
        DocumentFooter o = new DocumentFooter("/word/footer1.xml", this.msHelper);
        this.overrides.add(new ContOverride(o));
        return o;
    }

    @Override
    public String getPartName() {
        return "[Content_Types].xml";
    }

    public void addAllFileParts(Collection<FilePart> pull) {
        for (ContOverride o : this.overrides) {
            pull.add(o.getContentElement());
        }
    }

    static class ContOverride
    implements XmlWriter {
        private final ContentElement contentElement;

        private ContOverride(ContentElement contentElement) {
            this.contentElement = contentElement;
        }

        public String getPartName() {
            return this.contentElement.getPartName();
        }

        public ContentType getContentType() {
            return this.contentElement.getContentType();
        }

        @Override
        public void write(PrintStream out) {
            out.print("<Override PartName=\"" + this.getPartName() + "\" ContentType=\"" + this.getContentType().getXmlns() + "\" />");
        }

        public ContentElement getContentElement() {
            return this.contentElement;
        }
    }

    static class Default
    implements XmlWriter {
        private final String extention;
        private final ContentType contentType;

        public Default(ContentType contentType, String extention) {
            this.contentType = contentType;
            this.extention = extention;
            assert (contentType != null);
            assert (extention != null && extention.length() > 0);
        }

        @Override
        public void write(PrintStream out) {
            out.print("<Default Extension=\"" + this.extention + "\" ContentType=\"" + this.contentType.getXmlns() + "\" />");
        }

        public String getExtention() {
            return this.extention;
        }

        public ContentType getContentType() {
            return this.contentType;
        }
    }
}

