/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import kz.greetgo.msoffice.docx.XmlWriter;

public class Margins
implements XmlWriter {
    private final String tagName;
    private final Margin left = new Margin(Margin.Side.LEFT);
    private final Margin top = new Margin(Margin.Side.TOP);
    private final Margin right = new Margin(Margin.Side.RIGHT);
    private final Margin bottom = new Margin(Margin.Side.BOTTOM);

    Margins(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public void write(PrintStream out) {
        if (this.isEmpty()) {
            return;
        }
        out.print("<" + this.tagName + ">");
        this.getLeft().write(out);
        this.getTop().write(out);
        this.getRight().write(out);
        this.getBottom().write(out);
        out.print("</" + this.tagName + ">");
    }

    public Margin getLeft() {
        return this.left;
    }

    public Margin getTop() {
        return this.top;
    }

    public Margin getRight() {
        return this.right;
    }

    public Margin getBottom() {
        return this.bottom;
    }

    public void setWidth(int width) {
        this.getLeft().setWidth(width);
        this.getTop().setWidth(width);
        this.getRight().setWidth(width);
        this.getBottom().setWidth(width);
    }

    public boolean isEmpty() {
        return this.getLeft().isEmpty() && this.getTop().isEmpty() && this.getRight().isEmpty() && this.getBottom().isEmpty();
    }

    public static class Margin
    implements XmlWriter {
        private final Side side;
        private int width = 0;

        public boolean isEmpty() {
            return this.width == 0;
        }

        public Margin(Side side) {
            this.side = side;
            assert (side != null);
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }

        @Override
        public void write(PrintStream out) {
            out.print("<" + this.getSide().getCode() + " w:w=\"" + this.getWidth() + "\" w:type=\"dxa\" />");
        }

        public Side getSide() {
            return this.side;
        }

        public static enum Side {
            LEFT("w:left"),
            TOP("w:top"),
            RIGHT("w:right"),
            BOTTOM("w:bottom");

            private final String code;

            private Side(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }
        }
    }
}

