/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.util.Date;
import kz.greetgo.msoffice.util.UtilOffice;
import kz.greetgo.msoffice.xlsx.reader.Borders;
import kz.greetgo.msoffice.xlsx.reader.Cell;
import kz.greetgo.msoffice.xlsx.reader.SheetReader;
import kz.greetgo.msoffice.xlsx.reader.XlsxReaderContext;
import kz.greetgo.msoffice.xlsx.reader.model.CellXf;
import kz.greetgo.msoffice.xlsx.reader.model.ColData;
import kz.greetgo.msoffice.xlsx.reader.model.HorizontalAlign;
import kz.greetgo.msoffice.xlsx.reader.model.NumFmtData;
import kz.greetgo.msoffice.xlsx.reader.model.VerticalAlign;

public class CellReader
implements Cell {
    private final XlsxReaderContext context;
    private final int rowIndex;
    final ColData col;
    private final SheetReader sheetReader;

    public CellReader(XlsxReaderContext context, int rowIndex, ColData col, SheetReader sheetReader) {
        this.context = context;
        this.rowIndex = rowIndex;
        this.col = col;
        this.sheetReader = sheetReader;
    }

    public static CellReader empty(XlsxReaderContext context, int rowIndex, int colIndex, SheetReader sheetReader) {
        return new CellReader(context, rowIndex, ColData.empty(colIndex), sheetReader);
    }

    @Override
    public String asText() {
        switch (this.col.valueType) {
            case UNKNOWN: {
                if (this.isDate()) {
                    return this.context.dateToStr(this.asDate());
                }
                return this.col.value;
            }
            case STR: {
                return this.context.storedStrings.get(Long.parseLong(this.col.value));
            }
        }
        throw new RuntimeException("Unknown ValueType = " + (Object)((Object)this.col.valueType));
    }

    @Override
    public String format() {
        CellXf cellXf = this.context.styles.getCellXf(this.col.style);
        if (cellXf.numFmtId == null) {
            return "";
        }
        NumFmtData numFmtData = this.context.styles.numFmtDataIdMap.get(cellXf.numFmtId);
        return numFmtData == null ? "" : UtilOffice.fnn(numFmtData.formatCode, "");
    }

    @Override
    public boolean isDate() {
        return UtilOffice.isFormatForDate(this.format());
    }

    @Override
    public Date asDate() {
        return UtilOffice.excelToDate(this.col.value);
    }

    @Override
    public Borders borders() {
        return borderSide -> this.context.getBorderStyle(borderSide, this.rowIndex, this.col, this.sheetReader);
    }

    @Override
    public HorizontalAlign horAlign() {
        return this.context.styles.getCellXf((int)this.col.style).horizontalAlign;
    }

    @Override
    public VerticalAlign vertAlign() {
        return this.context.styles.getCellXf((int)this.col.style).verticalAlign;
    }
}

