/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractList;
import kz.greetgo.msoffice.xlsx.reader.Ref;

public class RefList
extends AbstractList<Ref>
implements AutoCloseable {
    private final Path filePath;
    private final RandomAccessFile file;
    private final byte[] buffer = new byte[12];

    public RefList(Path filePath) {
        this.filePath = filePath;
        try {
            this.file = new RandomAccessFile(filePath.toFile(), "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Ref get(int index) {
        try {
            this.file.seek(12L * (long)index);
            int count = this.file.read(this.buffer);
            if (count < 12) {
                throw new IndexOutOfBoundsException("index = " + index + " but must be < " + this.size());
            }
            return Ref.readFrom(this.buffer, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        try {
            return (int)(this.file.length() / 12L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
            Files.delete(this.filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(int index, Ref ref) {
        try {
            this.file.seek(12L * (long)index);
            ref.writeTo(this.buffer, 0);
            this.file.write(this.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

