/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.xlsx.reader.CellReader;
import kz.greetgo.msoffice.xlsx.reader.Row;
import kz.greetgo.msoffice.xlsx.reader.SheetReader;
import kz.greetgo.msoffice.xlsx.reader.XlsxReaderContext;
import kz.greetgo.msoffice.xlsx.reader.model.ColData;
import kz.greetgo.msoffice.xlsx.reader.model.RowData;

public class RowReader
implements Row {
    private final XlsxReaderContext context;
    private final SheetReader sheetReader;
    private final int rowIndex;
    private final RowData rowData;
    private List<CellReader> cells = null;

    public RowReader(XlsxReaderContext context, SheetReader sheetReader, int rowIndex) {
        this.context = context;
        this.sheetReader = sheetReader;
        this.rowIndex = rowIndex;
        this.rowData = sheetReader.sheetData.getRowData(rowIndex);
    }

    private List<CellReader> cells() {
        if (this.cells != null) {
            return this.cells;
        }
        if (this.rowData.cols.isEmpty()) {
            this.cells = new ArrayList<CellReader>();
            return this.cells;
        }
        int colCount = this.rowData.cols.get((int)(this.rowData.cols.size() - 1)).col + 1;
        ArrayList<CellReader> cells = new ArrayList<CellReader>();
        int colIndex = 0;
        for (int col = 0; col < colCount; ++col) {
            ColData colData = this.rowData.cols.get(colIndex);
            if (col < colData.col) {
                cells.add(CellReader.empty(this.context, this.rowIndex, col, this.sheetReader));
                continue;
            }
            cells.add(new CellReader(this.context, this.rowIndex, colData, this.sheetReader));
            ++colIndex;
        }
        this.cells = cells;
        return this.cells;
    }

    @Override
    public double height() {
        return this.rowData.heightAsDouble();
    }

    @Override
    public CellReader cell(int i) {
        if (i < 0) {
            throw new RuntimeException("Illegal column index = " + i);
        }
        return i < this.cells().size() ? this.cells().get(i) : CellReader.empty(this.context, this.rowIndex, i, this.sheetReader);
    }

    @Override
    public int count() {
        return this.rowData.cols.size();
    }
}

