/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import kz.greetgo.msoffice.util.UtilOffice;
import kz.greetgo.msoffice.xlsx.reader.Sheet;
import kz.greetgo.msoffice.xlsx.reader.SheetHandler;
import kz.greetgo.msoffice.xlsx.reader.SheetReader;
import kz.greetgo.msoffice.xlsx.reader.SheetRef;
import kz.greetgo.msoffice.xlsx.reader.StoredStrings;
import kz.greetgo.msoffice.xlsx.reader.StringsHandler;
import kz.greetgo.msoffice.xlsx.reader.StylesHandler;
import kz.greetgo.msoffice.xlsx.reader.WorkbookHandler;
import kz.greetgo.msoffice.xlsx.reader.XlsxReaderContext;
import kz.greetgo.msoffice.xlsx.reader.model.SheetData;
import kz.greetgo.msoffice.xlsx.reader.model.WorkbookData;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XlsxReader
implements AutoCloseable {
    private final XlsxReaderContext context;
    private final Map<Integer, SheetData> sheetDataMap = new HashMap<Integer, SheetData>();
    private final WorkbookData workbook = new WorkbookData();
    private final Path tempDir;
    private Random random = new Random();
    private final List<Path> tmpFiles = new ArrayList<Path>();
    private final Map<Integer, SheetReader> sheetReaderMap = new HashMap<Integer, SheetReader>();
    private Sheet tabSelectedSheet = null;
    private static final Pattern SHEET_FILE = Pattern.compile("xl/worksheets/sheet(\\d+)\\.xml");

    private Path tmp(Path tmp) {
        this.tmpFiles.add(tmp);
        return tmp;
    }

    private final Path createTmpFile(String prefixName) {
        if (this.tempDir == null) {
            try {
                return this.tmp(Files.createTempFile(prefixName, ".bin", new FileAttribute[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.random == null) {
            this.random = new Random();
        }
        return this.tmp(this.tempDir.resolve(prefixName + "-" + Math.abs(this.random.nextLong()) + ".bin"));
    }

    public XlsxReader() {
        this(null);
    }

    public XlsxReader(Path tempDir) {
        this.tempDir = tempDir;
        StoredStrings storedStrings = new StoredStrings(this.createTmpFile("stored-strings-ref"), this.createTmpFile("stored-strings-content"));
        this.context = new XlsxReaderContext(storedStrings);
    }

    @Override
    public void close() {
        this.context.storedStrings.close();
        this.tmpFiles.stream().map(Path::toFile).forEach(File::delete);
    }

    private static ZipInputStream wrapInZip(InputStream inputStream) {
        return inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(inputStream, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void read(InputStream inputStream) {
        block26: {
            try {
                zipInputStream = XlsxReader.wrapInZip(inputStream);
                var3_5 = null;
                try {
                    while (true) lbl-1000:
                    // 7 sources

                    {
                        if ((entry = zipInputStream.getNextEntry()) == null) {
                            break block26;
                        }
                        entryName = entry.getName();
                        try {
                            if ("xl/sharedStrings.xml".equals(entryName)) {
                                XlsxReader.doParsing(zipInputStream, new StringsHandler(this.context.storedStrings));
                            }
                            if ("xl/styles.xml".equals(entryName)) {
                                XlsxReader.doParsing(zipInputStream, new StylesHandler(this.context.styles));
                            }
                            if ("xl/workbook.xml".equals(entryName)) {
                                XlsxReader.doParsing(zipInputStream, new WorkbookHandler(this.workbook));
                            }
                            matcher = XlsxReader.SHEET_FILE.matcher(entryName);
                            if (!matcher.matches()) ** GOTO lbl-1000
                            sheetData = new SheetData(Integer.parseInt(matcher.group(1)), (Function<String, Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createTmpFile(java.lang.String ), (Ljava/lang/String;)Ljava/nio/file/Path;)((XlsxReader)this));
                            this.sheetDataMap.put(sheetData.id, sheetData);
                            XlsxReader.doParsing(zipInputStream, new SheetHandler(sheetData));
                        }
                        finally {
                            zipInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var4_8) {
                    var3_5 = var4_8;
                    throw var4_8;
                }
                finally {
                    if (zipInputStream != null) {
                        if (var3_5 != null) {
                            try {
                                zipInputStream.close();
                            }
                            catch (Throwable var4_7) {
                                var3_5.addSuppressed(var4_7);
                            }
                        } else {
                            zipInputStream.close();
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void doParsing(InputStream inputStream, ContentHandler contentHandler) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(contentHandler);
        reader.parse(new InputSource(UtilOffice.copy(inputStream)));
    }

    public int sheetCount() {
        return this.workbook.sheetRefList.size();
    }

    public void setDateFormat(DateFormat dateFormat) {
        Objects.requireNonNull(dateFormat);
        this.context.dateFormat = dateFormat;
    }

    public Sheet sheet(int index) {
        SheetReader sheetReader = this.sheetReaderMap.get(index);
        if (sheetReader != null) {
            return sheetReader;
        }
        SheetRef ref = this.workbook.sheetRefList.get(index);
        SheetData sheetData = this.sheetDataMap.get(ref.id);
        Objects.requireNonNull(sheetData, "index = " + index + ", sheet id = " + ref.id);
        SheetReader sheetReader2 = new SheetReader(this.context, ref, sheetData);
        this.sheetReaderMap.put(index, sheetReader2);
        return sheetReader2;
    }

    public Sheet tabSelectedSheet() {
        if (this.tabSelectedSheet != null) {
            return this.tabSelectedSheet;
        }
        for (int i = 0; i < this.sheetCount(); ++i) {
            Sheet sheet = this.sheet(i);
            if (!sheet.tabSelected()) continue;
            this.tabSelectedSheet = sheet;
            return this.tabSelectedSheet;
        }
        throw new RuntimeException("No tab selected sheet: sheet count = " + this.sheetCount());
    }

    void printSharedStrings(PrintStream out) {
        long strCount = this.context.storedStrings.strCount();
        if (strCount == 0L) {
            return;
        }
        int len = ("" + (strCount - 1L)).length();
        int i = 0;
        while ((long)i < strCount) {
            out.println(UtilOffice.toLenLeft(len, "" + i, " ") + " - " + this.context.storedStrings.get(i));
            ++i;
        }
    }
}

