/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kz.greetgo.msoffice.xlsx.reader.Ref;
import kz.greetgo.msoffice.xlsx.reader.RefList;
import kz.greetgo.msoffice.xlsx.reader.model.ColumnInfo;
import kz.greetgo.msoffice.xlsx.reader.model.MergeCell;
import kz.greetgo.msoffice.xlsx.reader.model.RowData;

public class SheetData
implements AutoCloseable {
    public final List<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
    public final int id;
    private final RefList rowRefList;
    private final RefList mergeCellRefList;
    private final RandomAccessFile data;
    public boolean tabSelected = false;
    public int frozenRowCount = 0;
    private int rowSize = 0;
    private int mergeCellSize = 0;

    public SheetData(int id, Function<String, Path> createTmpFile) {
        this.id = id;
        this.rowRefList = new RefList(createTmpFile.apply("sheet" + id + "-row-ref-list"));
        this.mergeCellRefList = new RefList(createTmpFile.apply("sheet" + id + "-merge-cell-ref-list"));
        try {
            this.data = new RandomAccessFile(createTmpFile.apply("sheet" + id + "-data").toFile(), "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addRow(int index, RowData rowData) {
        if (index < this.rowSize) {
            throw new IllegalArgumentException("index must be >= rowSize: index = " + index + ", rowSize = " + this.rowSize);
        }
        while (this.rowSize < index) {
            this.append(RowData.empty());
        }
        this.append(rowData);
    }

    private void append(RowData rowData) {
        try {
            Ref ref = Ref.of(this.data.length(), rowData.byteSize());
            this.rowRefList.add(ref);
            this.rowSize = this.rowRefList.size();
            byte[] buffer = new byte[ref.length];
            rowData.writeTo(buffer, 0);
            this.data.seek(this.data.length());
            this.data.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int rowSize() {
        return this.rowSize;
    }

    public RowData getRowData(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index = " + index + " bug must be >= 0");
        }
        if (index >= this.rowSize) {
            return RowData.empty();
        }
        try {
            Ref ref = this.rowRefList.get(index);
            byte[] buffer = new byte[ref.length];
            this.data.seek(ref.offset);
            this.assertReadOk(this.data.read(buffer), buffer);
            return RowData.readFrom(buffer, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertReadOk(int readCount, byte[] buffer) {
        if (readCount != buffer.length) {
            throw new RuntimeException("readCount != buffer.length, BUT must be equals: readCount =" + readCount + ", buffer.length = " + buffer.length);
        }
    }

    @Override
    public void close() {
        try {
            this.data.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addMergeCell(MergeCell mergeCell) {
        try {
            Ref ref = Ref.of(this.data.length(), mergeCell.byteSize());
            this.mergeCellRefList.add(ref);
            this.mergeCellSize = this.mergeCellRefList.size();
            byte[] buffer = new byte[ref.length];
            mergeCell.writeBytes(buffer, 0);
            this.data.seek(this.data.length());
            this.data.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int mergeCellSize() {
        return this.mergeCellSize;
    }

    public MergeCell getMergeCell(int index) {
        if (index < 0 || index >= this.mergeCellSize) {
            throw new IndexOutOfBoundsException("index = " + index + ", mergeCellSize = " + this.mergeCellSize);
        }
        try {
            Ref ref = this.mergeCellRefList.get(index);
            byte[] buffer = new byte[ref.length];
            this.data.seek(ref.offset);
            this.assertReadOk(this.data.read(buffer), buffer);
            return MergeCell.readFrom(buffer, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

