/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.docx.Borders;
import kz.greetgo.msoffice.docx.ColMergeStatus;
import kz.greetgo.msoffice.docx.FlowElement;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.Margins;
import kz.greetgo.msoffice.docx.Para;
import kz.greetgo.msoffice.docx.Shd;
import kz.greetgo.msoffice.docx.TableCol;
import kz.greetgo.msoffice.docx.VertAlign;
import kz.greetgo.msoffice.docx.XmlWriter;

public class TableCell
implements XmlWriter {
    private final TableCol tableCol;
    private final String ownerPartName;
    private final MSHelper msHelper;
    private VertAlign vertAlign = VertAlign.TOP;
    private Integer width = null;
    private Integer gridSpan;
    private ColMergeStatus colMergeStatus = ColMergeStatus.NONE;
    private List<FlowElement> elements = new ArrayList<FlowElement>();
    private final Borders borders = new Borders("w:tcBorders");
    private final Margins margins = new Margins("w:tcMar");
    private final Shd shd = new Shd();

    TableCell(TableCol tableCol, String ownerPartName, MSHelper msHelper) {
        this.tableCol = tableCol;
        this.ownerPartName = ownerPartName;
        this.msHelper = msHelper;
        assert (tableCol != null);
    }

    @Override
    public void write(PrintStream out) {
        out.print("<w:tc>");
        ArrayList<String> options = new ArrayList<String>();
        if (this.getVertAlign() != null && this.getVertAlign() != VertAlign.TOP) {
            options.add("<w:vAlign w:val=\"" + this.getVertAlign().getCode() + "\" />");
        }
        int w = this.tableCol.getWidth();
        if (this.getWidth() != null) {
            w = this.getWidth();
        }
        if (w > 0) {
            options.add("<w:tcW w:w=\"" + w + "\" w:type=\"dxa\" />");
        }
        if (this.getGridSpan() != null) {
            options.add("<w:gridSpan w:val=\"" + this.getGridSpan() + "\" />");
        }
        boolean needTcPr = false;
        if (options.size() > 0) {
            needTcPr = true;
        }
        if (!this.getBorders().isEmpty()) {
            needTcPr = true;
        }
        if (!this.getMargins().isEmpty()) {
            needTcPr = true;
        }
        if (this.colMergeStatus != ColMergeStatus.NONE) {
            needTcPr = true;
        }
        if (needTcPr) {
            out.print("<w:tcPr>");
        }
        for (String s : options) {
            out.print(s);
        }
        this.getBorders().write(out);
        this.getMargins().write(out);
        this.getShd().write(out);
        out.print("<w:hideMark />");
        switch (this.colMergeStatus) {
            case RESTART: {
                out.print("<w:vMerge w:val=\"restart\" />");
                break;
            }
            case CONTINUE: {
                out.print("<w:vMerge />");
            }
        }
        if (needTcPr) {
            out.print("</w:tcPr>");
        }
        for (FlowElement e : this.elements) {
            e.write(out);
        }
        if (this.elements.size() == 0) {
            out.print("<w:p />");
        }
        out.print("</w:tc>");
    }

    public Para createPara() {
        return this.createPara(null);
    }

    public Para createPara(Para example) {
        Para ret = new Para(this.ownerPartName, this.msHelper);
        if (example != null) {
            ret.copyDecorationFrom(example);
        } else {
            Para defaultPara = this.msHelper.getDefaultPara();
            if (defaultPara != null) {
                ret.copyDecorationFrom(defaultPara);
            }
        }
        this.elements.add(ret);
        return ret;
    }

    public Borders getBorders() {
        return this.borders;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setVertAlign(VertAlign vertAlign) {
        this.vertAlign = vertAlign;
    }

    public VertAlign getVertAlign() {
        return this.vertAlign;
    }

    public Margins getMargins() {
        return this.margins;
    }

    public Integer getGridSpan() {
        return this.gridSpan;
    }

    public void setGridSpan(Integer gridSpan) {
        this.gridSpan = gridSpan;
    }

    public Shd getShd() {
        return this.shd;
    }

    public void mergeRestart() {
        this.colMergeStatus = ColMergeStatus.RESTART;
    }

    public void mergeCotinue() {
        this.colMergeStatus = ColMergeStatus.CONTINUE;
    }
}

