/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import kz.greetgo.msoffice.xlsx.gen.Align;

public class Alignment {
    private Align horizontal;
    private Align vertical;
    private boolean wrapText = false;

    public void clean() {
        this.horizontal = null;
        this.vertical = null;
        this.wrapText = false;
    }

    public Alignment() {
    }

    public Alignment(Alignment x) {
        this.horizontal = x.horizontal;
        this.vertical = x.vertical;
        this.wrapText = x.wrapText;
    }

    boolean isStandart() {
        return this.horizontal == null && this.vertical == null && !this.wrapText;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.horizontal == null ? 0 : this.horizontal.hashCode());
        result = 31 * result + (this.vertical == null ? 0 : this.vertical.hashCode());
        result = 31 * result + (this.wrapText ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alignment other = (Alignment)obj;
        if (this.horizontal != other.horizontal) {
            return false;
        }
        if (this.vertical != other.vertical) {
            return false;
        }
        return this.wrapText == other.wrapText;
    }

    public Align horizontal() {
        return this.horizontal;
    }

    public Align vertical() {
        return this.vertical;
    }

    public void setHorizontal(Align horizontal) {
        this.horizontal = horizontal;
    }

    public void setVertical(Align vertical) {
        this.vertical = vertical;
    }

    public Alignment horizontalCenter() {
        this.horizontal = Align.center;
        return this;
    }

    public Alignment verticalCenter() {
        this.vertical = Align.center;
        return this;
    }

    public Alignment horizontalNull() {
        this.horizontal = null;
        return this;
    }

    public Alignment verticalNull() {
        this.vertical = null;
        return this;
    }

    public Alignment left() {
        this.horizontal = Align.left;
        return this;
    }

    public Alignment right() {
        this.horizontal = Align.right;
        return this;
    }

    public Alignment top() {
        this.vertical = Align.top;
        return this;
    }

    public Alignment bottom() {
        this.vertical = Align.bottom;
        return this;
    }

    public void print(PrintStream out) {
        out.print("<alignment");
        if (this.horizontal != null) {
            out.print(" horizontal=\"" + this.horizontal.name() + "\"");
        }
        if (this.vertical != null) {
            out.print(" vertical=\"" + this.vertical.name() + "\"");
        }
        if (this.isWrapText()) {
            out.print(" wrapText=\"1\"");
        }
        out.println(" />");
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
    }

    public Alignment wrap() {
        this.setWrapText(true);
        return this;
    }

    public Alignment noWrap() {
        this.setWrapText(false);
        return this;
    }
}

