/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.parse;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kz.greetgo.msoffice.util.UtilOffice;
import kz.greetgo.msoffice.xlsx.parse.Cell;
import kz.greetgo.msoffice.xlsx.parse.CellHandler;
import kz.greetgo.msoffice.xlsx.parse.RowHandler;
import kz.greetgo.msoffice.xlsx.parse.Sheet;
import kz.greetgo.msoffice.xlsx.parse.XmlIn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SheetHandler
extends DefaultHandler
implements Sheet {
    private final Connection connection;
    private final int sheetNo;
    private final String name;
    private boolean active;
    private final XmlIn in = new XmlIn();
    PreparedStatement cellsInsertPS = null;
    private int currentBachSize = 0;
    private static final int MAX_BATCH_SIZE = 2000;
    final CellInfo cell = new CellInfo();
    private StringBuilder textBuilder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SheetHandler(Connection connection, String sheetPathName, int sheetNo) {
        this.connection = connection;
        this.sheetNo = sheetNo;
        int startLen = "xl/worksheets/".length();
        int endLen = ".xml".length();
        this.name = sheetPathName.substring(startLen, sheetPathName.length() - endLen);
        try (PreparedStatement ps = connection.prepareStatement("insert into sheets (id, name) values (?, ?)");){
            ps.setInt(1, sheetNo);
            ps.setString(2, this.name);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.cellsInsertPS = this.connection.prepareStatement("insert into cells (sheet_id, n_row, n_col, t, s, v) values (?, ?, ?, ?, ?, ?)");
            this.currentBachSize = 0;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.finishInsertion();
    }

    public void finishInsertion() {
        if (this.cellsInsertPS == null) {
            return;
        }
        try {
            if (this.currentBachSize > 0) {
                this.commit();
            }
            this.cellsInsertPS.close();
            this.cellsInsertPS = null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.textBuilder = null;
        this.in.stepIn(qName);
        if ("worksheet/sheetData/row/c".equals(this.in.current())) {
            this.cell.r = attributes.getValue("r");
            this.cell.t = attributes.getValue("t");
            this.cell.s = attributes.getValue("s");
        }
        if ("worksheet/sheetViews/sheetView".equals(this.in.current()) && "1".equals(attributes.getValue("tabSelected"))) {
            this.setSheetIsActive(true);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("worksheet/sheetData/row/c/v".equals(this.in.current())) {
            this.cell.v = this.text();
            this.appendCell(this.cell);
        }
        this.in.stepOut();
    }

    private String text() {
        if (this.textBuilder == null) {
            return "";
        }
        return this.textBuilder.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textBuilder == null) {
            this.textBuilder = new StringBuilder();
        }
        this.textBuilder.append(ch, start, length);
    }

    private void appendCell(CellInfo cell) {
        try {
            this.appendCellEx(cell);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendCellEx(CellInfo cell) throws SQLException {
        cell.calcRowCol();
        this.cellsInsertPS.setLong(1, this.sheetNo);
        this.cellsInsertPS.setLong(2, cell.row - 1L);
        this.cellsInsertPS.setInt(3, cell.col);
        this.cellsInsertPS.setString(4, cell.t);
        this.cellsInsertPS.setString(5, cell.s);
        this.cellsInsertPS.setString(6, cell.v);
        this.cellsInsertPS.addBatch();
        ++this.currentBachSize;
        if (this.currentBachSize >= 2000) {
            this.commit();
        }
    }

    private void commit() throws SQLException {
        this.cellsInsertPS.executeBatch();
        this.connection.commit();
        this.currentBachSize = 0;
    }

    private void setSheetIsActive(boolean active) {
        try {
            this.setSheetIsActiveEx(active);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void setSheetIsActiveEx(boolean active) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update sheets set is_active = ? where id = ?");){
            ps.setInt(1, active ? 1 : 0);
            ps.setLong(2, this.sheetNo);
            ps.executeUpdate();
            this.connection.commit();
        }
        this.active = active;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void scanCells(CellHandler handler) {
        try {
            this.scanCellsEx(handler);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanCellsEx(CellHandler handler) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select * from cells where sheet_id = ? order by sheet_id, n_row, n_col");){
            ps.setInt(1, this.sheetNo);
            try (ResultSet rs = ps.executeQuery();){
                MyCell cell = new MyCell();
                while (rs.next()) {
                    cell.read(rs);
                    handler.handle(cell);
                }
            }
        }
        this.connection.commit();
    }

    private String getStrByNo(long strNo) {
        try {
            return this.getStrByNoEx(strNo);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStrByNoEx(long strNo) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("select value from strs where nom = ?");){
            String string;
            ps.setLong(1, strNo);
            ResultSet rs = ps.executeQuery();
            try {
                String ret = null;
                if (rs.next()) {
                    ret = rs.getString(1);
                }
                string = ret;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
    }

    @Override
    public List<Cell> loadRow(int row) {
        try {
            return this.loadRowEx(row);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cell> loadRowEx(int row) throws SQLException {
        ArrayList<Cell> ret = new ArrayList<Cell>();
        try (PreparedStatement ps = this.connection.prepareStatement("select * from cells where sheet_id = ? and n_row = ? order by sheet_id, n_row, n_col");){
            ps.setInt(1, this.sheetNo);
            ps.setInt(2, row);
            try (ResultSet rs = ps.executeQuery();){
                int lastCol = -1;
                while (rs.next()) {
                    MyCell cell = new MyCell();
                    cell.read(rs);
                    while (++lastCol < cell.col) {
                        ret.add(new MyCell(row, lastCol));
                    }
                    ret.add(cell);
                }
            }
        }
        this.connection.commit();
        return ret;
    }

    @Override
    public void scanRows(int colCountInRow, RowHandler handler) {
        try {
            this.scanRowsEx(colCountInRow, handler);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanRowsEx(int colCountInRow, RowHandler handler) throws Exception {
        ArrayList<Cell> row = new ArrayList<Cell>();
        int i = 0;
        while (i < colCountInRow) {
            MyCell cell = new MyCell();
            cell.col = i++;
            row.add(cell);
        }
        try (PreparedStatement ps = this.connection.prepareStatement("select * from cells where sheet_id = ? order by sheet_id, n_row, n_col");){
            ps.setInt(1, this.sheetNo);
            try (ResultSet rs = ps.executeQuery();){
                int currRowIndex = -1;
                int currColIndex = 213213;
                while (rs.next()) {
                    int colIndex = rs.getInt("n_col");
                    if (colIndex >= row.size()) continue;
                    int rowIndex = rs.getInt("n_row");
                    if (currRowIndex < rowIndex) {
                        currColIndex = -1;
                        if (currRowIndex > -1) {
                            handler.handle(row, currRowIndex);
                        }
                        for (Cell cell : row) {
                            cell.cleanData();
                        }
                        while (++currRowIndex < rowIndex) {
                            for (Cell cell : row) {
                                cell.row = currRowIndex;
                            }
                            handler.handle(row, currRowIndex);
                        }
                        assert (currRowIndex == rowIndex);
                        for (Cell cell : row) {
                            cell.row = rowIndex;
                        }
                    }
                    while (++currColIndex < colIndex) {
                        ((Cell)row.get(currColIndex)).cleanData();
                    }
                    ((MyCell)row.get(colIndex)).readData(rs);
                }
                handler.handle(row, currRowIndex);
            }
        }
    }

    private class MyCell
    extends Cell {
        MyCell() {
        }

        MyCell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        @Override
        public String asStr() {
            if (this.isStr()) {
                return SheetHandler.this.getStrByNo(Long.parseLong(this.v));
            }
            return this.v;
        }

        @Override
        public Date asDate() {
            if (this.isStr()) {
                return null;
            }
            return UtilOffice.excelToDate(this.v);
        }

        @Override
        public Integer asInt() {
            BigDecimal bd = this.asBigDecimal();
            return bd == null ? null : Integer.valueOf(bd.intValue());
        }

        @Override
        public Long asLong() {
            BigDecimal bd = this.asBigDecimal();
            return bd == null ? null : Long.valueOf(bd.longValue());
        }

        @Override
        public BigDecimal asBigDecimal() {
            if (this.isStr()) {
                return null;
            }
            if (this.v == null) {
                return null;
            }
            return new BigDecimal(this.v);
        }

        public void read(ResultSet rs) throws SQLException {
            this.row = rs.getInt("n_row");
            this.col = rs.getInt("n_col");
            this.readData(rs);
        }

        public void readData(ResultSet rs) throws SQLException {
            this.s = rs.getString("s");
            this.t = rs.getString("t");
            this.v = rs.getString("v");
        }
    }

    private static class CellInfo {
        String r;
        String t;
        String s;
        String v;
        long row;
        int col;

        private CellInfo() {
        }

        public void calcRowCol() {
            char c;
            int index;
            for (index = 0; index < this.r.length() && ('0' > (c = this.r.charAt(index)) || c > '9'); ++index) {
            }
            this.row = Long.parseLong(this.r.substring(index));
            this.col = UtilOffice.parseLettersNumber(this.r.substring(0, index));
        }
    }
}

