/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.util.Objects;
import kz.greetgo.msoffice.util.BinUtil;

public class Ref {
    public final long offset;
    public final int length;
    public static final int SIZE = 12;

    private Ref(long offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public String toString() {
        return "Ref{offset=" + this.offset + ", length=" + this.length + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ref ref = (Ref)o;
        return this.offset == ref.offset && this.length == ref.length;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length);
    }

    public static Ref of(long offset, int length) {
        return new Ref(offset, length);
    }

    public static Ref readFrom(byte[] buffer, int offset) {
        long refOffset = BinUtil.readLong(buffer, offset);
        int refLength = BinUtil.readInt(buffer, offset + 8);
        return Ref.of(refOffset, refLength);
    }

    public void writeTo(byte[] buffer, int offset) {
        BinUtil.writeLong(this.offset, buffer, offset);
        BinUtil.writeInt(this.length, buffer, offset + 8);
    }
}

