/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kz.greetgo.msoffice.docx.ContentElement;
import kz.greetgo.msoffice.docx.ContentType;
import kz.greetgo.msoffice.docx.Font;
import kz.greetgo.msoffice.docx.XmlWriter;

public class FontTableContentElement
implements ContentElement {
    private final String partName;
    private Map<String, FontElement> elements = new HashMap<String, FontElement>();

    private FontTableContentElement(String partName) {
        this.partName = partName;
        assert (partName != null);
    }

    public static FontTableContentElement createDefault(String partName) {
        FontTableContentElement ret = new FontTableContentElement(partName);
        ret.initDefault();
        return ret;
    }

    public Font getFont(String name) {
        if (!this.elements.containsKey(name)) {
            throw new IllegalArgumentException("No font with name = " + name);
        }
        return this.elements.get(name).getFont();
    }

    private void initDefault() {
        LinkedList<String> c = new LinkedList<String>();
        String name = "Calibri";
        c.clear();
        c.add("<w:panose1 w:val=\"020F0502020204030204\" />");
        c.add("<w:charset w:val=\"CC\" />");
        c.add("<w:family w:val=\"swiss\" />");
        c.add("<w:pitch w:val=\"variable\" />");
        c.add("<w:sig w:usb0=\"A00002EF\" w:usb1=\"4000207B\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"0000009F\" w:csb1=\"00000000\" />");
        this.elements.put(name, new FontElement(name, c.iterator()));
        name = "Times New Roman";
        c.clear();
        c.add("<w:panose1 w:val=\"02020603050405020304\" />");
        c.add("<w:charset w:val=\"CC\" />");
        c.add("<w:family w:val=\"roman\" />");
        c.add("<w:pitch w:val=\"variable\" />");
        c.add("<w:sig w:usb0=\"20002A87\" w:usb1=\"80000000\" w:usb2=\"00000008\" w:usb3=\"00000000\" w:csb0=\"000001FF\" w:csb1=\"00000000\" />");
        this.elements.put(name, new FontElement(name, c.iterator()));
        name = "Tahoma";
        c.clear();
        c.add("<w:panose1 w:val=\"020B0604030504040204\" />");
        c.add("<w:charset w:val=\"CC\" />");
        c.add("<w:family w:val=\"swiss\" />");
        c.add("<w:pitch w:val=\"variable\" />");
        c.add("<w:sig w:usb0=\"61002A87\" w:usb1=\"80000000\" w:usb2=\"00000008\" w:usb3=\"00000000\" w:csb0=\"000101FF\" w:csb1=\"00000000\" />");
        this.elements.put(name, new FontElement(name, c.iterator()));
        name = "Cambria";
        c.clear();
        c.add("<w:panose1 w:val=\"02040503050406030204\" />");
        c.add("<w:charset w:val=\"CC\" />");
        c.add("<w:family w:val=\"roman\" />");
        c.add("<w:pitch w:val=\"variable\" />");
        c.add("<w:sig w:usb0=\"A00002EF\" w:usb1=\"4000004B\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"0000009F\" w:csb1=\"00000000\" />");
        this.elements.put(name, new FontElement(name, c.iterator()));
        name = "Arial";
        c.clear();
        c.add(" <w:panose1 w:val=\"020B0604020202020204\" />");
        c.add("<w:charset w:val=\"CC\" />");
        c.add("<w:family w:val=\"swiss\" />");
        c.add("<w:pitch w:val=\"variable\" />");
        c.add("<w:sig w:usb0=\"20002A87\" w:usb1=\"80000000\" w:usb2=\"00000008\" w:usb3=\"00000000\"  w:csb0=\"000001FF\" w:csb1=\"00000000\" />");
        this.elements.put(name, new FontElement(name, c.iterator()));
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public void write(PrintStream out) {
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        out.print("<w:fonts xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">");
        for (FontElement e : this.elements.values()) {
            e.write(out);
        }
        out.print("</w:fonts>");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.FONT_TABLE;
    }

    public static class FontElement
    implements XmlWriter {
        private final String name;
        private List<String> xmlContent = new ArrayList<String>();
        private Font font = null;

        public FontElement(String name, Iterator<String> xmlContentIterator) {
            this.name = name;
            while (xmlContentIterator.hasNext()) {
                this.xmlContent.add(xmlContentIterator.next());
            }
        }

        public Font getFont() {
            if (this.font == null) {
                this.font = new Font();
                this.font.name = this.name;
            }
            return this.font;
        }

        @Override
        public void write(PrintStream out) {
            out.print("<w:font w:name=\"" + this.getName() + "\">");
            for (String s : this.xmlContent) {
                out.print(s);
            }
            out.print("</w:font>");
        }

        public String getName() {
            return this.name;
        }
    }
}

