/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class BinUtil {
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_SHORT = 2;

    public static void writeInt(int value, byte[] buffer, int offset) {
        buffer[offset + 0] = (byte)((value & 0xFF) >> 0);
        buffer[offset + 1] = (byte)((value & 0xFF00) >> 8);
        buffer[offset + 2] = (byte)((value & 0xFF0000) >> 16);
        buffer[offset + 3] = (byte)((value & 0xFF000000) >> 24);
    }

    public static int readInt(byte[] buffer, int offset) {
        return (buffer[offset + 0] & 0xFF) << 0 | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static void writeLong(long value, byte[] buffer, int offset) {
        buffer[offset + 0] = (byte)((value & 0xFFL) >> 0);
        buffer[offset + 1] = (byte)((value & 0xFF00L) >> 8);
        buffer[offset + 2] = (byte)((value & 0xFF0000L) >> 16);
        buffer[offset + 3] = (byte)((value & 0xFF000000L) >> 24);
        buffer[offset + 4] = (byte)((value & 0xFF00000000L) >> 32);
        buffer[offset + 5] = (byte)((value & 0xFF0000000000L) >> 40);
        buffer[offset + 6] = (byte)((value & 0xFF000000000000L) >> 48);
        buffer[offset + 7] = (byte)((value & 0xFF00000000000000L) >> 56);
    }

    public static long readLong(byte[] buffer, int offset) {
        return ((long)buffer[offset + 0] & 0xFFL) << 0 | ((long)buffer[offset + 1] & 0xFFL) << 8 | ((long)buffer[offset + 2] & 0xFFL) << 16 | ((long)buffer[offset + 3] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 32 | ((long)buffer[offset + 5] & 0xFFL) << 40 | ((long)buffer[offset + 6] & 0xFFL) << 48 | ((long)buffer[offset + 7] & 0xFFL) << 56;
    }

    public static void writeStr(String value, byte[] buffer, int offset) {
        if (value == null) {
            BinUtil.writeInt(-1, buffer, offset);
            return;
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        BinUtil.writeInt(bytes.length, buffer, offset);
        System.arraycopy(bytes, 0, buffer, offset + 4, bytes.length);
    }

    public static int sizeOfStr(String value) {
        return 4 + (value == null ? 0 : value.getBytes(StandardCharsets.UTF_8).length);
    }

    public static String readStr(byte[] buffer, int offset) {
        int length = BinUtil.readInt(buffer, offset);
        if (length < 0) {
            return null;
        }
        return new String(buffer, offset + 4, length, StandardCharsets.UTF_8);
    }

    public static void writeShort(short value, byte[] buffer, int offset) {
        buffer[offset + 0] = (byte)((value & 0xFF) >> 0);
        buffer[offset + 1] = (byte)((value & 0xFF00) >> 8);
    }

    public static short readShort(byte[] buffer, int offset) {
        return (short)((buffer[offset + 0] & 0xFF) << 0 | (buffer[offset + 1] & 0xFF) << 8);
    }

    public static void writeBigInt(BigInteger value, byte[] buffer, int offset) {
        if (value == null) {
            BinUtil.writeInt(-1, buffer, offset);
            return;
        }
        byte[] bytes = value.toByteArray();
        BinUtil.writeInt(bytes.length, buffer, offset);
        System.arraycopy(bytes, 0, buffer, offset + 4, bytes.length);
    }

    public static BigInteger readBigInt(byte[] buffer, int offset) {
        int length = BinUtil.readInt(buffer, offset);
        if (length < 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, offset + 4, bytes, 0, bytes.length);
        return new BigInteger(bytes);
    }

    public static int sizeOfBigInt(BigInteger value) {
        return 4 + (value == null ? 0 : value.toByteArray().length);
    }

    public static int sizeOfBd(BigDecimal value) {
        if (value == null) {
            return 4;
        }
        byte[] bytes = value.unscaledValue().toByteArray();
        return 8 + bytes.length;
    }

    public static void writeBd(BigDecimal value, byte[] buffer, int offset) {
        if (value == null) {
            BinUtil.writeInt(-1, buffer, offset);
            return;
        }
        byte[] bytes = value.unscaledValue().toByteArray();
        int scale = value.scale();
        BinUtil.writeInt(bytes.length, buffer, offset);
        BinUtil.writeInt(scale, buffer, offset + 4);
        System.arraycopy(bytes, 0, buffer, offset + 8, bytes.length);
    }

    public static BigDecimal readBd(byte[] buffer, int offset) {
        int length = BinUtil.readInt(buffer, offset);
        if (length < 0) {
            return null;
        }
        int scale = BinUtil.readInt(buffer, offset + 4);
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, offset + 8, bytes, 0, length);
        BigInteger unscaledValue = new BigInteger(bytes);
        return new BigDecimal(unscaledValue, scale);
    }
}

