/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.util.HashMap;
import java.util.Objects;
import kz.greetgo.msoffice.xlsx.reader.RowReader;
import kz.greetgo.msoffice.xlsx.reader.Sheet;
import kz.greetgo.msoffice.xlsx.reader.SheetRef;
import kz.greetgo.msoffice.xlsx.reader.XlsxReaderContext;
import kz.greetgo.msoffice.xlsx.reader.model.MergeCell;
import kz.greetgo.msoffice.xlsx.reader.model.SheetData;

public class SheetReader
implements Sheet {
    private final SheetRef sheetRef;
    final SheetData sheetData;
    private final XlsxReaderContext context;
    private HashMap<Integer, MergeCell> mergeCellCache = new HashMap();

    public SheetReader(XlsxReaderContext context, SheetRef sheetRef, SheetData sheetData) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(sheetData);
        Objects.requireNonNull(sheetRef);
        this.context = context;
        this.sheetRef = sheetRef;
        this.sheetData = sheetData;
    }

    @Override
    public String name() {
        return this.sheetRef.name;
    }

    @Override
    public int index() {
        return this.sheetRef.index;
    }

    @Override
    public int rowCount() {
        return this.sheetData.rowSize();
    }

    @Override
    public RowReader row(int rowIndex) {
        return new RowReader(this.context, this, rowIndex);
    }

    @Override
    public boolean tabSelected() {
        return this.sheetData.tabSelected;
    }

    @Override
    public int frozenRowCount() {
        return this.sheetData.frozenRowCount;
    }

    @Override
    public int cellMergeCount() {
        return this.sheetData.mergeCellSize();
    }

    @Override
    public MergeCell cellMerge(int i) {
        if (this.mergeCellCache.size() > 1000) {
            this.mergeCellCache = new HashMap();
        }
        return this.mergeCellCache.computeIfAbsent(i, this.sheetData::getMergeCell);
    }
}

