/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.fastgen.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kz.greetgo.msoffice.util.UtilOffice;
import kz.greetgo.msoffice.xlsx.fastgen.simple.SimpleRowStyle;

public class SimpleFastXlsxFile {
    private final String workingDir;
    private int sheetNumber = 0;
    private double[] colWidths;
    private PrintStream outCurrentSheet = null;
    private PrintStream outSharedStrings = null;
    private int currentRow;
    private int newStringIndex = 0;

    public SimpleFastXlsxFile(String tmpDir) {
        this.workingDir = tmpDir + "/" + UUID.randomUUID().toString();
        new File(this.workingDir).mkdirs();
        try {
            this.prepareFiles();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFiles() throws Exception {
        try (ZipInputStream zin = new ZipInputStream(this.getClass().getResourceAsStream("SimpleXlsxFile.template.xlsx"));){
            ZipEntry entry;
            byte[] buf = new byte[4096];
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.getName().endsWith("/")) continue;
                File entryFile = new File(this.workingDir + "/zip/" + entry.getName());
                entryFile.getParentFile().mkdirs();
                try (FileOutputStream fout = new FileOutputStream(entryFile);){
                    int count;
                    while ((count = zin.read(buf)) >= 0) {
                        ((OutputStream)fout).write(buf, 0, count);
                    }
                }
                zin.closeEntry();
            }
        }
        this.openSharedStrings();
    }

    public void newSheet(double[] colWidths) {
        this.colWidths = colWidths;
        this.closeCurrentSheet();
        ++this.sheetNumber;
        try {
            this.outCurrentSheet = new PrintStream(this.workingDir + "/zip/xl/worksheets/sheet" + this.sheetNumber + ".xml", "UTF-8");
            this.outCurrentSheet.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            this.outCurrentSheet.println("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n  <dimension ref=\"A1:J4\" />\n  <sheetViews>\n    <sheetView tabSelected=\"1\" workbookViewId=\"0\">\n      <selection activeCell=\"A1\" sqref=\"A1\" />\n    </sheetView>\n  </sheetViews>\n  <sheetFormatPr defaultRowHeight=\"15\" />");
            this.outCurrentSheet.println("<cols>");
            for (int i = 1; i <= colWidths.length; ++i) {
                this.outCurrentSheet.println("<col min=\"" + i + "\" max=\"" + i + "\" width=\"" + colWidths[i - 1] + "\" customWidth=\"1\" />");
            }
            this.outCurrentSheet.println("</cols>");
            this.outCurrentSheet.println("<sheetData>");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.currentRow = 1;
    }

    public void appendRow(SimpleRowStyle rowStyle, String[] rowData) {
        if (rowData == null) {
            throw new NullPointerException("rowData == null");
        }
        if (rowData.length != this.colWidths.length) {
            throw new NullPointerException("rowData.length == " + rowData.length + " but must be == " + this.colWidths.length);
        }
        if (this.sheetNumber <= 0) {
            throw new RuntimeException("No sheet");
        }
        this.outCurrentSheet.print("<row r=\"" + this.currentRow + "\">");
        int C = rowData.length;
        for (int i = 0; i < C; ++i) {
            String r = " r = \"" + UtilOffice.toTablePosition(this.currentRow, i) + '\"';
            String s = this.getRowStyle(rowStyle);
            String value = rowData[i];
            if (value == null) {
                this.outCurrentSheet.println("<c " + r + s + " />");
                continue;
            }
            this.outCurrentSheet.println("<c " + r + s + " t=\"s\"><v>" + this.str(rowData[i]) + "</v></c>");
        }
        this.outCurrentSheet.println("</row>");
        ++this.currentRow;
    }

    private String getRowStyle(SimpleRowStyle rowStyle) {
        switch (rowStyle) {
            case NORMAL: {
                return "";
            }
            case GREEN: {
                return " s=\"1\"";
            }
        }
        throw new IllegalArgumentException("Unknown rowStyle = " + (Object)((Object)rowStyle));
    }

    public void complete(OutputStream output) {
        try {
            try {
                this.complete0(output);
            }
            finally {
                output.close();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void complete0(OutputStream output) throws Exception {
        this.closeCurrentSheet();
        ZipOutputStream zout = new ZipOutputStream(output);
        byte[] buffer = new byte[4096];
        new File(this.workingDir + "/zip/xl/workbook.xml").delete();
        new File(this.workingDir + "/zip/[Content_Types].xml").delete();
        new File(this.workingDir + "/zip/xl/_rels/workbook.xml.rels").delete();
        new File(this.workingDir + "/zip/docProps/app.xml").delete();
        new File(this.workingDir + "/zip/xl/sharedStrings.xml").delete();
        this.copyAll(zout, null, this.workingDir + "/zip", buffer);
        this.printWorkbook(zout);
        this.printContentTypes(zout);
        this.printWorkbookXmlRels(zout);
        this.printApp(zout);
        this.printSharedStrings(zout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAll(ZipOutputStream zout, String localDir, String realDir, byte[] buffer) throws Exception {
        for (String name : new File(realDir).list(null)) {
            String localName;
            File file = new File(realDir + "/" + name);
            String string = localName = localDir == null ? name : localDir + "/" + name;
            if (file.isDirectory()) {
                this.copyAll(zout, localName, realDir + "/" + name, buffer);
                continue;
            }
            if (!file.isFile()) continue;
            zout.putNextEntry(new ZipEntry(localName));
            try (FileInputStream fin = new FileInputStream(file);){
                int count;
                while ((count = fin.read(buffer)) >= 0) {
                    zout.write(buffer, 0, count);
                }
            }
            zout.closeEntry();
        }
    }

    private void closeCurrentSheet() {
        if (this.outCurrentSheet == null) {
            return;
        }
        this.outCurrentSheet.print("</sheetData><pageMargins left=\"0.7\" right=\"0.7\" top=\"0.75\" bottom=\"0.75\" header=\"0.3\" footer=\"0.3\" /></worksheet>");
        this.outCurrentSheet.close();
        this.outCurrentSheet = null;
    }

    private void openSharedStrings() throws Exception {
        this.outSharedStrings = new PrintStream(this.workingDir + "/sharedStrings.xml", "UTF-8");
    }

    private int str(String s) {
        s = s.replaceAll("<", "&lt;");
        this.outSharedStrings.print("<si><t>" + s + "</t></si>");
        return this.newStringIndex++;
    }

    private void printWorkbook(ZipOutputStream zout) throws Exception {
        zout.putNextEntry(new ZipEntry("xl/workbook.xml"));
        PrintStream out = new PrintStream((OutputStream)zout, false, "UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("<workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n  <fileVersion appName=\"xl\" lastEdited=\"4\" lowestEdited=\"4\" rupBuild=\"4505\" />\n  <workbookPr defaultThemeVersion=\"124226\" />\n  <bookViews>\n    <workbookView xWindow=\"240\" yWindow=\"15\" windowWidth=\"25680\" windowHeight=\"10305\" />\n  </bookViews>");
        out.println("<sheets>");
        for (int i = 0; i < this.sheetNumber; ++i) {
            out.println("<sheet name=\"\u041b\u0438\u0441\u0442" + (i + 1) + "\" sheetId=\"" + (i + 1) + "\" r:id=\"rId" + (i + 4) + "\" />");
        }
        out.println("</sheets>");
        out.println("<calcPr calcId=\"124519\" />\n</workbook>");
        out.flush();
        zout.closeEntry();
    }

    private void printContentTypes(ZipOutputStream zout) throws Exception {
        zout.putNextEntry(new ZipEntry("[Content_Types].xml"));
        PrintStream out = new PrintStream((OutputStream)zout, false, "UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n  <Override PartName=\"/xl/theme/theme1.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.theme+xml\" />\n  <Override PartName=\"/xl/styles.xml\"\n    ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\" />\n  <Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" />\n  <Default Extension=\"xml\" ContentType=\"application/xml\" />\n  <Override PartName=\"/xl/workbook.xml\"\n    ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\" />\n  <Override PartName=\"/docProps/app.xml\"\n    ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\" />\n  <Override PartName=\"/xl/sharedStrings.xml\"\n    ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\" />\n  <Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\" />");
        for (int i = 0; i < this.sheetNumber; ++i) {
            out.println("<Override PartName=\"/xl/worksheets/sheet" + (i + 1) + ".xml\"\n    ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\" />");
        }
        out.println("</Types>");
        out.flush();
        zout.closeEntry();
    }

    private void printWorkbookXmlRels(ZipOutputStream zout) throws Exception {
        zout.putNextEntry(new ZipEntry("xl/_rels/workbook.xml.rels"));
        PrintStream out = new PrintStream((OutputStream)zout, false, "UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n  <Relationship Id=\"rId3\"\n    Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\" Target=\"sharedStrings.xml\" />\n  <Relationship Id=\"rId1\"\n    Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\" Target=\"styles.xml\" />\n  <Relationship Id=\"rId2\"\n    Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme\" Target=\"theme/theme1.xml\" />");
        for (int i = 0; i < this.sheetNumber; ++i) {
            out.println("<Relationship Id=\"rId" + (i + 4) + "\"\n    Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\" Target=\"worksheets/sheet" + (i + 1) + ".xml\" />");
        }
        out.println("</Relationships>");
        out.flush();
        zout.closeEntry();
    }

    private void printApp(ZipOutputStream zout) throws Exception {
        zout.putNextEntry(new ZipEntry("docProps/app.xml"));
        PrintStream out = new PrintStream((OutputStream)zout, false, "UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\"\n  xmlns:vt=\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\">\n  <Application>Microsoft Excel</Application>\n  <DocSecurity>0</DocSecurity>\n  <ScaleCrop>false</ScaleCrop>\n  <HeadingPairs>\n    <vt:vector size=\"2\" baseType=\"variant\">\n      <vt:variant>\n        <vt:lpstr>\u041b\u0438\u0441\u0442\u044b</vt:lpstr>\n      </vt:variant>\n      <vt:variant>\n        <vt:i4>3</vt:i4>\n      </vt:variant>\n    </vt:vector>\n  </HeadingPairs>\n  <TitlesOfParts>");
        out.println("<vt:vector size=\"" + this.sheetNumber + "\" baseType=\"lpstr\">");
        for (int i = 0; i < this.sheetNumber; ++i) {
            out.println("<vt:lpstr>\u041b\u0438\u0441\u0442" + (i + 1) + "</vt:lpstr>");
        }
        out.println("</vt:vector>");
        out.println("</TitlesOfParts>\n  <Company>Microsoft</Company>\n  <LinksUpToDate>false</LinksUpToDate>\n  <SharedDoc>false</SharedDoc>\n  <HyperlinksChanged>false</HyperlinksChanged>\n  <AppVersion>12.0000</AppVersion>\n</Properties>");
        out.flush();
        zout.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSharedStrings(ZipOutputStream zout) throws Exception {
        this.outSharedStrings.close();
        this.outSharedStrings = null;
        zout.putNextEntry(new ZipEntry("xl/sharedStrings.xml"));
        PrintStream out = new PrintStream((OutputStream)zout, false, "UTF-8");
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"" + this.newStringIndex + "\" uniqueCount=\"" + this.newStringIndex + "\">");
        out.flush();
        try (FileInputStream in = new FileInputStream(this.workingDir + "/sharedStrings.xml");){
            int count;
            byte[] buf = new byte[4096];
            while ((count = ((InputStream)in).read(buf)) >= 0) {
                zout.write(buf, 0, count);
            }
        }
        out.println("</sst>");
        out.flush();
        zout.closeEntry();
    }
}

