/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.gen;

import java.io.PrintStream;
import kz.greetgo.msoffice.xlsx.gen.Color;
import kz.greetgo.msoffice.xlsx.gen.FontName;

public class Font {
    private FontName name = FontName.Calibri;
    private int size = 11;
    private Color color = null;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underlined = false;

    public Font() {
    }

    public Font(Font x) {
        this.name = x.name;
        this.size = x.size;
        this.color = Color.copy(x.color);
        this.bold = x.bold;
        this.italic = x.italic;
        this.underlined = x.underlined;
    }

    public static Font copy(Font font) {
        if (font == null) {
            return null;
        }
        return new Font(font);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bold ? 1231 : 1237);
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.italic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + (this.underlined ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Font other = (Font)obj;
        if (this.bold != other.bold) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.italic != other.italic) {
            return false;
        }
        if (this.name != other.name) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.underlined == other.underlined;
    }

    public FontName getName() {
        return this.name;
    }

    public void setName(FontName name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    public void print(PrintStream out) {
        out.println("<font>");
        if (this.italic) {
            out.println("<i />");
        }
        if (this.underlined) {
            out.println("<u />");
        }
        if (this.bold) {
            out.println("<b />");
        }
        out.println("<sz val=\"" + this.size + "\" />");
        if (this.color != null) {
            out.println("<color rgb=\"" + this.color.str() + "\" />");
        }
        out.println("<name val=\"" + this.name.str() + "\" />");
        out.println("<family val=\"" + this.name.getFamily() + "\" />");
        out.println("<charset val=\"" + this.name.getCharset() + "\" />");
        if (this.name.getScheme() != null) {
            out.println("<scheme val=\"" + this.name.getScheme() + "\" />");
        }
        out.println("</font>");
    }

    public Font bold() {
        this.setBold(true);
        return this;
    }

    public Font noBold() {
        this.setBold(false);
        return this;
    }

    public Font italic() {
        this.setItalic(true);
        return this;
    }

    public Font noItalic() {
        this.setItalic(false);
        return this;
    }

    public Font underlined() {
        this.setUnderlined(true);
        return this;
    }

    public Font noUnderlined() {
        this.setUnderlined(false);
        return this;
    }

    public Font color(Color color) {
        this.setColor(color);
        return this;
    }

    public Font size(int size) {
        this.setSize(size);
        return this;
    }

    public Font name(FontName name) {
        this.setName(name);
        return this;
    }
}

