/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import kz.greetgo.msoffice.xlsx.reader.Ref;

public class StoredStrings
implements AutoCloseable {
    private final Path refPath;
    private final Path contentPath;
    private final RandomAccessFile ref;
    private final RandomAccessFile content;
    private long strCount = 0L;

    public StoredStrings(Path refPath, Path contentPath) {
        this.refPath = refPath;
        this.contentPath = contentPath;
        try {
            this.ref = new RandomAccessFile(refPath.toFile(), "rw");
            this.content = new RandomAccessFile(contentPath.toFile(), "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.ref.close();
            this.content.close();
            this.refPath.toFile().delete();
            this.contentPath.toFile().delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long strCount() {
        return this.strCount;
    }

    public long append(String str) {
        Objects.requireNonNull(str);
        try {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            long offset = this.content.length();
            this.content.seek(offset);
            this.content.write(bytes, 0, bytes.length);
            Ref refData = Ref.of(offset, bytes.length);
            byte[] refBytes = new byte[12];
            refData.writeTo(refBytes, 0);
            long refOffset = this.strCount++ * 12L;
            this.ref.seek(refOffset);
            this.ref.write(refBytes, 0, refBytes.length);
            return refOffset / 12L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String get(long i) {
        try {
            long refOffset = i * 12L;
            this.ref.seek(refOffset);
            byte[] refBytes = new byte[12];
            this.ref.read(refBytes);
            Ref ref = Ref.readFrom(refBytes, 0);
            byte[] buffer = new byte[ref.length];
            this.content.seek(ref.offset);
            this.content.read(buffer);
            return new String(buffer, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

