/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.xlsx.reader;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.greetgo.msoffice.util.UtilOffice;
import kz.greetgo.msoffice.xlsx.reader.AbstractXmlHandler;
import kz.greetgo.msoffice.xlsx.reader.model.Border;
import kz.greetgo.msoffice.xlsx.reader.model.Border4;
import kz.greetgo.msoffice.xlsx.reader.model.BorderSide;
import kz.greetgo.msoffice.xlsx.reader.model.BorderStyle;
import kz.greetgo.msoffice.xlsx.reader.model.CellStyleXf;
import kz.greetgo.msoffice.xlsx.reader.model.CellXf;
import kz.greetgo.msoffice.xlsx.reader.model.FontData;
import kz.greetgo.msoffice.xlsx.reader.model.HorizontalAlign;
import kz.greetgo.msoffice.xlsx.reader.model.NumFmtData;
import kz.greetgo.msoffice.xlsx.reader.model.StylesData;
import kz.greetgo.msoffice.xlsx.reader.model.VerticalAlign;
import org.xml.sax.Attributes;

public class StylesHandler
extends AbstractXmlHandler {
    private final StylesData styles;
    private FontData font = null;
    private Border4 border4 = null;
    private CellXf cellXf = null;
    private CellStyleXf cellStyleXf = null;
    private static final Pattern PATH_BORDER = Pattern.compile("/styleSheet/borders/border/(left|right|top|bottom|diagonal)");

    public StylesHandler(StylesData styles) {
        this.styles = styles;
    }

    @Override
    protected void startTag(String tagPath, Attributes attributes) {
        if ("/styleSheet/fonts/font".equals(tagPath)) {
            this.font = this.styles.newFont();
            return;
        }
        if ("/styleSheet/fonts/font/sz".equals(tagPath)) {
            this.font.size = Double.valueOf(attributes.getValue("val"));
            return;
        }
        if ("/styleSheet/fonts/font/name".equals(tagPath)) {
            this.font.name = attributes.getValue("val");
            return;
        }
        if ("/styleSheet/fonts/font/b".equals(tagPath)) {
            this.font.bold = true;
            return;
        }
        if ("/styleSheet/borders/border".equals(tagPath)) {
            this.border4 = this.styles.newBorder4();
            return;
        }
        Matcher matcher = PATH_BORDER.matcher(tagPath);
        if (matcher.matches()) {
            Border border = this.border4.get(BorderSide.valueOf(matcher.group(1)));
            border.style = BorderStyle.from(attributes.getValue("style")).orElse(null);
            return;
        }
        if ("/styleSheet/cellStyleXfs/xf".equals(tagPath)) {
            this.cellStyleXf = this.styles.newCellStyleXf();
            this.cellStyleXf.numFmtId = UtilOffice.strToInt(attributes.getValue("numFmtId"));
            this.cellStyleXf.fontId = UtilOffice.strToInt(attributes.getValue("fontId"));
            this.cellStyleXf.fillId = UtilOffice.strToInt(attributes.getValue("fillId"));
            this.cellStyleXf.borderId = UtilOffice.strToInt(attributes.getValue("borderId"));
            return;
        }
        if ("/styleSheet/cellXfs/xf".equals(tagPath)) {
            this.cellXf = this.styles.newCellXf();
            this.cellXf.numFmtId = "1".equals(attributes.getValue("applyNumberFormat")) ? UtilOffice.strToInt(attributes.getValue("numFmtId")) : null;
            this.cellXf.fontId = UtilOffice.strToInt(attributes.getValue("fontId"));
            this.cellXf.fillId = UtilOffice.strToInt(attributes.getValue("fillId"));
            this.cellXf.borderId = UtilOffice.strToInt(attributes.getValue("borderId"));
            this.cellXf.xfId = UtilOffice.strToInt(attributes.getValue("xfId"));
            return;
        }
        if ("/styleSheet/cellXfs/xf/alignment".equals(tagPath)) {
            this.cellXf.verticalAlign = VerticalAlign.valueOrNull(attributes.getValue("vertical"));
            this.cellXf.horizontalAlign = HorizontalAlign.valueOrNull(attributes.getValue("horizontal"));
            return;
        }
        if ("/styleSheet/numFmts/numFmt".equals(tagPath)) {
            NumFmtData numFmt = new NumFmtData(attributes.getValue("numFmtId"));
            numFmt.formatCode = attributes.getValue("formatCode");
            this.styles.numFmtDataIdMap.put(numFmt.id, numFmt);
            return;
        }
    }

    @Override
    protected void endTag(String tagPath) {
    }
}

