/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.awt.Color;
import java.io.PrintStream;
import kz.greetgo.msoffice.docx.LineStyle;
import kz.greetgo.msoffice.docx.XmlWriter;
import kz.greetgo.msoffice.util.UtilOffice;

public class Borders
implements XmlWriter {
    private final String tagName;
    private final Border left = new Border(Side.LEFT);
    private final Border right = new Border(Side.RIGHT);
    private final Border top = new Border(Side.TOP);
    private final Border bottom = new Border(Side.BOTTOM);
    private final Border insideH = new Border(Side.INSIDE_H);
    private final Border insideV = new Border(Side.INSIDE_V);

    public Borders(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public void write(PrintStream out) {
        if (this.isEmpty()) {
            return;
        }
        out.print("<" + this.getTagName() + ">");
        this.getLeft().write(out);
        this.getTop().write(out);
        this.getRight().write(out);
        this.getBottom().write(out);
        this.getInsideH().write(out);
        this.getInsideV().write(out);
        out.print("</" + this.getTagName() + ">");
    }

    public boolean isEmpty() {
        return this.getLeft().isEmpty() && this.getTop().isEmpty() && this.getRight().isEmpty() && this.getBottom().isEmpty() && this.getInsideH().isEmpty() && this.getInsideV().isEmpty();
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.getLeft().setLineStyle(lineStyle);
        this.getTop().setLineStyle(lineStyle);
        this.getRight().setLineStyle(lineStyle);
        this.getBottom().setLineStyle(lineStyle);
        this.getInsideH().setLineStyle(lineStyle);
        this.getInsideV().setLineStyle(lineStyle);
    }

    public void setSize(int size) {
        this.getLeft().setSize(size);
        this.getTop().setSize(size);
        this.getRight().setSize(size);
        this.getBottom().setSize(size);
        this.getInsideH().setSize(size);
        this.getInsideV().setSize(size);
    }

    public Border getLeft() {
        return this.left;
    }

    public Border getRight() {
        return this.right;
    }

    public Border getTop() {
        return this.top;
    }

    public Border getBottom() {
        return this.bottom;
    }

    public Border getInsideH() {
        return this.insideH;
    }

    public Border getInsideV() {
        return this.insideV;
    }

    public String getTagName() {
        return this.tagName;
    }

    public static class Border
    implements XmlWriter {
        private final Side side;
        private LineStyle lineStyle = LineStyle.NONE;
        private int size = 4;
        private int space = 0;
        private Color color = null;

        private Border(Side side) {
            this.side = side;
        }

        public Side getSide() {
            return this.side;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public void setSpace(int space) {
            this.space = space;
        }

        public int getSpace() {
            return this.space;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void setLineStyle(LineStyle lineStyle) {
            this.lineStyle = lineStyle;
        }

        public LineStyle getLineStyle() {
            return this.lineStyle;
        }

        public boolean isEmpty() {
            if (this.getLineStyle() == null) {
                return true;
            }
            return this.getLineStyle() == LineStyle.NONE;
        }

        @Override
        public void write(PrintStream out) {
            if (this.isEmpty()) {
                return;
            }
            String sColor = "auto";
            if (this.getColor() != null) {
                sColor = UtilOffice.toHEX(this.getColor());
            }
            out.print("<" + this.getSide().getCode() + " w:val=\"" + this.getLineStyle().getCode() + "\" w:sz=\"" + this.getSize() + "\" w:space=\"" + this.getSpace() + "\" w:color=\"" + sColor + "\" />");
        }
    }

    public static enum Side {
        LEFT("w:left"),
        TOP("w:top"),
        RIGHT("w:right"),
        BOTTOM("w:bottom"),
        INSIDE_H("w:insideH"),
        INSIDE_V("w:insideV");

        private final String code;

        private Side(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

