/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kz.greetgo.msoffice.docx.BinaryFilePart;
import kz.greetgo.msoffice.docx.Content;
import kz.greetgo.msoffice.docx.Document;
import kz.greetgo.msoffice.docx.DocumentFooter;
import kz.greetgo.msoffice.docx.DocumentHeader;
import kz.greetgo.msoffice.docx.FilePart;
import kz.greetgo.msoffice.docx.Font;
import kz.greetgo.msoffice.docx.FontTableContentElement;
import kz.greetgo.msoffice.docx.InputSource;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.Para;
import kz.greetgo.msoffice.docx.Reference;
import kz.greetgo.msoffice.docx.Relationship;
import kz.greetgo.msoffice.docx.RelationshipMap;
import kz.greetgo.msoffice.docx.Run;
import kz.greetgo.msoffice.util.UtilOffice;

public class Docx {
    private Map<String, RelationshipMap> relationShipMaps = new HashMap<String, RelationshipMap>();
    private int nextRelationshipId = 1;
    private boolean mainRelationsInitiated = false;
    private int nextImageNumber = 1;
    private MSHelper msHelper = new MSHelper(){

        @Override
        public Relationship createRelationshipForImage(String ownerPartName, final InputSource inputSource) {
            Docx.this.getContent().checkExistsDefaultImagePng();
            final Relationship r = new Relationship();
            r.setType(Relationship.Type.IMAGE);
            r.setId("rId" + Docx.this.nextRelationshipId++);
            r.setTarget("media/image" + Docx.this.nextImageNumber++ + ".png");
            Docx.this.getRelationshipMap(ownerPartName).put(r);
            Docx.this.binaryParts.add(new BinaryFilePart(){

                @Override
                public InputStream openInputStream() throws Exception {
                    return inputSource.openInputStream();
                }

                @Override
                public String getPartName() {
                    return "/word/" + r.getTarget();
                }
            });
            return r;
        }

        @Override
        public Font getFont(String name) {
            return Docx.this.getFontTableContentElement().getFont(name);
        }

        @Override
        public Para getDefaultPara() {
            return Docx.this.defaultPara;
        }
    };
    private FontTableContentElement fontTableContentElement = null;
    private Para defaultPara = null;
    private Content content = null;
    private boolean headerConnected = false;
    private boolean footerConnected = false;
    private List<BinaryFilePart> binaryParts = new ArrayList<BinaryFilePart>();

    public Document getDocument() {
        this.checkInit();
        return this.getContent().getDocument();
    }

    private void checkInit() {
        if (!this.mainRelationsInitiated) {
            this.initMainRelations();
            this.mainRelationsInitiated = true;
        }
    }

    private void initMainRelations() {
        RelationshipMap mainRSet = RelationshipMap.createWithPartName("/_rels/.rels");
        this.relationShipMaps.put(mainRSet.getPartName(), mainRSet);
        Relationship r = new Relationship();
        r.setType(Relationship.Type.OFFICE_DOCUMENT);
        r.setId("rId" + this.nextRelationshipId++);
        r.setTarget("word/document.xml");
        mainRSet.put(r);
        r = new Relationship();
        r.setType(Relationship.Type.CORE_PROPERTIES);
        r.setId("rId" + this.nextRelationshipId++);
        r.setTarget("docProps/core.xml");
        mainRSet.put(r);
        r = new Relationship();
        r.setType(Relationship.Type.EXTENDED_PROPERTIES);
        r.setId("rId" + this.nextRelationshipId++);
        r.setTarget("docProps/app.xml");
        mainRSet.put(r);
    }

    private FontTableContentElement getFontTableContentElement() {
        if (this.fontTableContentElement == null) {
            this.fontTableContentElement = this.getContent().getFontTableContentElement();
            Document doc = this.getDocument();
            RelationshipMap rsm = this.getRelationshipMap(doc.getPartName());
            Relationship r = new Relationship();
            r.setTarget("fontTable.xml");
            r.setId("rId" + this.nextRelationshipId++);
            r.setType(Relationship.Type.FONT_TABLE);
            rsm.put(r);
        }
        return this.fontTableContentElement;
    }

    public Para getTemplatePara() {
        if (this.defaultPara == null) {
            this.defaultPara = new Para(null, this.msHelper);
        }
        return this.defaultPara;
    }

    private Content getContent() {
        if (this.content == null) {
            this.content = Content.createDefaultContent(this.msHelper);
        }
        return this.content;
    }

    private RelationshipMap getRelationshipMap(String subjectPartName) {
        RelationshipMap ret = this.relationShipMaps.get(subjectPartName);
        if (ret == null) {
            ret = RelationshipMap.createBySubjectPartName(subjectPartName);
            this.relationShipMaps.put(subjectPartName, ret);
        }
        return ret;
    }

    public DocumentHeader getOrCreateHeader() {
        this.checkInit();
        DocumentHeader header = this.getContent().getOrCreateHeader();
        if (!this.headerConnected) {
            Document doc = this.getDocument();
            RelationshipMap rsm = this.getRelationshipMap(doc.getPartName());
            Relationship r = new Relationship();
            r.setTarget("header1.xml");
            r.setId("rId" + this.nextRelationshipId++);
            r.setType(Relationship.Type.HEADER);
            rsm.put(r);
            Reference ref = new Reference();
            ref.setId(r.getId());
            ref.setTagName("w:headerReference");
            doc.addReference(ref);
            this.headerConnected = true;
        }
        return header;
    }

    public DocumentFooter getOrCreateFooter() {
        this.checkInit();
        DocumentFooter footer = this.getContent().getOrCreateFooter();
        if (!this.footerConnected) {
            Document doc = this.getDocument();
            RelationshipMap rsm = this.getRelationshipMap(doc.getPartName());
            Relationship r = new Relationship();
            r.setTarget("footer1.xml");
            r.setId("rId" + this.nextRelationshipId++);
            r.setType(Relationship.Type.FOOTER);
            rsm.put(r);
            Reference ref = new Reference();
            ref.setId(r.getId());
            ref.setTagName("w:footerReference");
            doc.addReference(ref);
            this.footerConnected = true;
        }
        return footer;
    }

    private void outFilePart(FilePart from, ZipOutputStream to) throws IOException {
        to.putNextEntry(new ZipEntry(UtilOffice.killFirstSlash(from.getPartName())));
        PrintStream out = new PrintStream((OutputStream)to, false, "UTF-8");
        from.write(out);
        out.flush();
        to.closeEntry();
    }

    public void write(OutputStream out) throws Exception {
        ZipOutputStream zout = out instanceof ZipOutputStream ? (ZipOutputStream)out : new ZipOutputStream(out);
        ArrayList<FilePart> parts = new ArrayList<FilePart>();
        parts.add(this.getContent());
        parts.addAll(this.relationShipMaps.values());
        this.getContent().addAllFileParts(parts);
        for (FilePart fp : parts) {
            this.outFilePart(fp, zout);
        }
        for (BinaryFilePart bfp : this.binaryParts) {
            zout.putNextEntry(new ZipEntry(UtilOffice.killFirstSlash(bfp.getPartName())));
            InputStream in = bfp.openInputStream();
            UtilOffice.copyStreams(in, zout);
            in.close();
            zout.closeEntry();
        }
        zout.flush();
        zout.close();
    }

    private void write0(File outFile) throws Exception {
        this.write(new FileOutputStream(outFile));
    }

    public void write(File outFile) {
        try {
            this.write0(outFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(String outFileName) {
        this.write(new File(outFileName));
    }

    public static void main(String[] args) {
        Docx w = new Docx();
        Document doc = w.getDocument();
        Para p = doc.createPara();
        Run r = p.createRun();
        r.setFontName("Times New Roman");
        r.addText("\u041f\u0440\u0438\u0432\u0435\u0442 \u0432\u0438\u0440!!!");
        w.write("build/u.docx");
        System.out.println("Complete.....");
    }
}

