/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.docx.Align;
import kz.greetgo.msoffice.docx.Borders;
import kz.greetgo.msoffice.docx.FlowElement;
import kz.greetgo.msoffice.docx.Font;
import kz.greetgo.msoffice.docx.Highlight;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.Run;
import kz.greetgo.msoffice.docx.TextVertAlign;
import kz.greetgo.msoffice.docx.Underline;

public class Para
implements FlowElement {
    private List<Run> runs = new ArrayList<Run>();
    private Align align = Align.LEFT;
    private Integer spacingBefore;
    private Integer spacingAfter;
    private Integer firstLine;
    private Integer left;
    private Integer right;
    private Integer spacingLine;
    private final Borders borders = new Borders("w:pBdr");
    private final String ownerPartName;
    private final MSHelper msHelper;
    private boolean bold = false;
    private boolean italic = false;
    private Underline underline = Underline.NONE;
    private TextVertAlign textVertAlign = TextVertAlign.NORMAL;
    private Highlight highlight = Highlight.NONE;
    private Color color = null;
    private Integer textSize = null;
    private Font font = null;

    public void setFontName(String name) {
        if (name == null) {
            this.font = null;
            return;
        }
        this.font = this.msHelper.getFont(name);
    }

    public void applyFor(Run run) {
        run.setBold(this.isBold());
        run.setItalic(this.isItalic());
        run.setUnderline(this.getUnderline());
        run.setTextVertAlign(this.getTextVertAlign());
        run.setHighlight(this.getHighlight());
        run.setColor(this.getColor());
        run.setTextSize(this.getTextSize());
        run.font = this.font;
    }

    public void copyDecorationFrom(Para p) {
        this.align = p.align;
        this.spacingBefore = p.spacingBefore;
        this.spacingAfter = p.spacingAfter;
        this.spacingLine = p.spacingLine;
        this.firstLine = p.firstLine;
        this.left = p.left;
        this.right = p.right;
        this.bold = p.bold;
        this.italic = p.italic;
        this.underline = p.underline;
        this.textVertAlign = p.textVertAlign;
        this.highlight = p.highlight;
        this.color = p.color;
        this.font = p.font;
        this.textSize = p.textSize;
    }

    public Para(String ownerPartName, MSHelper msHelper) {
        this.ownerPartName = ownerPartName;
        this.msHelper = msHelper;
    }

    @Override
    public void write(PrintStream out) {
        StringBuilder sb;
        ArrayList<String> options = new ArrayList<String>();
        if (this.getAlign() != null && this.getAlign() != Align.LEFT) {
            options.add("<w:jc w:val=\"" + this.getAlign().getCode() + "\" />");
        }
        if (this.getSpacingBefore() != null || this.getSpacingAfter() != null || this.getSpacingLine() != null) {
            sb = new StringBuilder();
            sb.append("<w:spacing ");
            if (this.getSpacingBefore() != null) {
                sb.append("w:before=\"");
                sb.append(this.getSpacingBefore());
                sb.append("\" ");
            }
            if (this.getSpacingAfter() != null) {
                sb.append("w:after=\"");
                sb.append(this.getSpacingAfter());
                sb.append("\" ");
            }
            if (this.getSpacingLine() != null) {
                sb.append("w:line=\"");
                sb.append(this.getSpacingLine());
                sb.append("\" ");
            }
            sb.append("/>");
            options.add(sb.toString());
        }
        if (this.getFirstLine() != null || this.getLeft() != null || this.getRight() != null) {
            sb = new StringBuilder();
            sb.append("<w:ind");
            if (this.getFirstLine() != null) {
                sb.append(" w:firstLine=\"");
                sb.append(this.getFirstLine());
                sb.append("\"");
            }
            if (this.getLeft() != null) {
                sb.append(" w:left=\"");
                sb.append(this.getLeft());
                sb.append("\"");
            }
            if (this.getRight() != null) {
                sb.append(" w:right=\"");
                sb.append(this.getRight());
                sb.append("\"");
            }
            sb.append(" />");
            options.add(sb.toString());
        }
        out.print("<w:p>");
        out.print("<w:pPr>");
        this.getBorders().write(out);
        for (String s : options) {
            out.print(s);
        }
        out.print("</w:pPr>");
        for (Run run : this.runs) {
            run.write(out);
        }
        out.print("</w:p>");
    }

    public void setAlign(Align textAlign) {
        this.align = textAlign;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setSpacingBefore(Integer spacingBefore) {
        this.spacingBefore = spacingBefore;
    }

    public Integer getSpacingBefore() {
        return this.spacingBefore;
    }

    public void setSpacingAfter(Integer spacingAfter) {
        this.spacingAfter = spacingAfter;
    }

    public Integer getSpacingAfter() {
        return this.spacingAfter;
    }

    public void setFirstLine(Integer firstLine) {
        this.firstLine = firstLine;
    }

    public Integer getFirstLine() {
        return this.firstLine;
    }

    public Run createRun() {
        Run ret = new Run(this.ownerPartName, this.msHelper);
        this.applyFor(ret);
        this.runs.add(ret);
        return ret;
    }

    public void addPageBreak() {
        this.createRun().addPageBreak();
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setUnderline(Underline underline) {
        this.underline = underline;
    }

    public Underline getUnderline() {
        return this.underline;
    }

    public void setTextVertAlign(TextVertAlign textVertAlign) {
        this.textVertAlign = textVertAlign;
    }

    public TextVertAlign getTextVertAlign() {
        return this.textVertAlign;
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight;
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setTextSize(Integer textSize) {
        this.textSize = textSize;
    }

    public Integer getTextSize() {
        return this.textSize;
    }

    public Font getFont() {
        return this.font;
    }

    public void setSpacingLine(Integer spacingLine) {
        this.spacingLine = spacingLine;
    }

    public Integer getSpacingLine() {
        return this.spacingLine;
    }

    public Borders getBorders() {
        return this.borders;
    }

    public void setRight(Integer right) {
        this.right = right;
    }

    public Integer getRight() {
        return this.right;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Integer getLeft() {
        return this.left;
    }
}

