/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.msoffice.docx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.msoffice.docx.Borders;
import kz.greetgo.msoffice.docx.FlowElement;
import kz.greetgo.msoffice.docx.MSHelper;
import kz.greetgo.msoffice.docx.Margins;
import kz.greetgo.msoffice.docx.Para;
import kz.greetgo.msoffice.docx.TableCol;
import kz.greetgo.msoffice.docx.TableRow;

public class Table
implements FlowElement {
    private final String ownerPartName;
    private final MSHelper msHelper;
    private List<TableCol> cols = new ArrayList<TableCol>();
    private List<TableRow> rows = new ArrayList<TableRow>();
    private final Borders borders = new Borders("w:tblBorders");
    private final Margins margins = new Margins("w:tblCellMar");
    private String tableLookVal;
    private Integer tableWidth;
    private Integer tblCellSpacing = 0;
    private final TableInfo tableInfo = new TableInfo();

    Table(String ownerPartName, MSHelper msHelper) {
        this.ownerPartName = ownerPartName;
        this.msHelper = msHelper;
    }

    public TableCol createCol() {
        TableCol ret = new TableCol(this.cols.size());
        this.cols.add(ret);
        return ret;
    }

    public TableRow createRow() {
        TableRow ret = new TableRow(this.tableInfo, this.ownerPartName, this.msHelper);
        this.rows.add(ret);
        return ret;
    }

    public TableRow getRow(int index) {
        return this.rows.get(index);
    }

    @Override
    public void write(PrintStream out) {
        out.print("<w:tbl>");
        if (this.cols.size() > 0) {
            out.print("<w:tblGrid>");
            for (TableCol c : this.cols) {
                c.write(out);
            }
            out.print("</w:tblGrid>");
        }
        out.print("<w:tblPr>");
        if (this.getTableWidth() != null) {
            out.print("<w:tblW w:w=\"" + this.getTableWidth() + "\" w:type=\"dxa\" />");
        }
        out.print("<w:tblCellSpacing w:w=\"0\" w:type=\"dxa\" />");
        this.getBorders().write(out);
        this.getMargins().write(out);
        if (this.tableLookVal != null) {
            out.print("<w:tblLook w:val=\"" + this.tableLookVal + "\" />");
        }
        out.print("</w:tblPr>");
        for (TableRow row : this.rows) {
            row.write(out);
        }
        out.print("</w:tbl>");
    }

    public Borders getBorders() {
        return this.borders;
    }

    public Para createExamplePara(Para anotherExample) {
        Para dp;
        Para ret = new Para("", null);
        if (anotherExample != null) {
            ret.copyDecorationFrom(anotherExample);
        } else if (this.msHelper != null && (dp = this.msHelper.getDefaultPara()) != null) {
            ret.copyDecorationFrom(dp);
        }
        return ret;
    }

    public String getTableLookVal() {
        return this.tableLookVal;
    }

    public void setTableLookVal(String tableLookVal) {
        this.tableLookVal = tableLookVal;
    }

    public Integer getTableWidth() {
        return this.tableWidth;
    }

    public void setTableWidth(Integer tableWidth) {
        this.tableWidth = tableWidth;
    }

    public Integer getTblCellSpacing() {
        return this.tblCellSpacing;
    }

    public void setTblCellSpacing(Integer tblCellSpacing) {
        this.tblCellSpacing = tblCellSpacing;
    }

    public Margins getMargins() {
        return this.margins;
    }

    class TableInfo {
        TableInfo() {
        }

        TableCol getTableCol(int colIndex) {
            if (colIndex < Table.this.cols.size()) {
                return (TableCol)Table.this.cols.get(colIndex);
            }
            for (int i = Table.this.cols.size(); i < colIndex; ++i) {
                Table.this.cols.add(new TableCol(i));
            }
            TableCol ret = new TableCol(Table.this.cols.size());
            if (colIndex == Table.this.cols.size()) {
                Table.this.cols.add(ret);
            }
            return ret;
        }
    }
}

